/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.BlockMatch;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.init.ModEntities;
import mod.vemerion.wizardstaff.init.ModItems;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effects;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MagicProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    protected final DataGenerator generator;
    private final String modid;

    public MagicProvider(DataGenerator generator, String modid) {
        this.generator = generator;
        this.modid = modid;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path folder = this.generator.func_200391_b();
        this.registerMagics((magic, s) -> {
            ResourceLocation key = magic.getRegistryName();
            String name = s == null || s.isEmpty() ? key.func_110623_a() : s;
            Path path = folder.resolve("data/" + this.modid + "/" + "wizard-staff-magics" + "/" + name + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)magic.write(), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't save magic {}", (Object)path, (Object)e);
            }
        });
    }

    protected void registerMagics(BiConsumer<Magic, String> c) {
        c.accept(ModMagics.BLAZE_POWDER_MAGIC.create().setParams(0.3f, -1, this.ing(Items.field_151065_br)), "");
        c.accept(ModMagics.BLUE_DYE_MAGIC.create().setParams(30.0f, 50, this.ing((ITag<Item>)Tags.Items.DYES_BLUE)), "");
        c.accept(ModMagics.BOOKSHELF_MAGIC.create().setParams(0.8f, -1, this.ing(Items.field_221651_bN)), "");
        c.accept(ModMagics.TRANSMUTATION_MAGIC.create().setAdditionalParams(Items.field_151062_by, SoundEvents.field_187621_J).setParams(12.0f, 15, this.ing(Items.field_151069_bo)), "bottle_magic");
        c.accept(ModMagics.BRICKS_MAGIC.create().setParams(50.0f, 30, this.ing(Items.field_221647_bL)), "");
        c.accept(ModMagics.BUILDER_MAGIC.create().setAdditionalParams(new ResourceLocation("wizard-staff", "wizard_home"), Direction.SOUTH, new BlockPos(3, 3, 3), new BlockPos(0, 0, 5)).setParams(400.0f, 80, this.ing(Items.field_221585_m)), "");
        c.accept(ModMagics.CARVED_PUMPKIN_MAGIC.create().setParams(50.0f, 40, this.ing(Items.field_221689_cG)), "");
        c.accept(ModMagics.CLOCK_MAGIC.create().setParams(1.0f, -1, this.ing(Items.field_151113_aN)), "");
        c.accept(ModMagics.DEAGE_MAGIC.create().setParams(30.0f, 30, this.ing(Items.field_151014_N)), "");
        this.magicArmor(c, Items.field_151151_aj, (Item)ModItems.DRUID_BOOTS);
        this.magicArmor(c, Items.field_151171_ah, (Item)ModItems.DRUID_CHESTPLATE);
        this.magicArmor(c, Items.field_151169_ag, (Item)ModItems.DRUID_HELMET);
        this.magicArmor(c, Items.field_151149_ai, (Item)ModItems.DRUID_LEGGINGS);
        this.magicArmor(c, Items.field_151167_ab, (Item)ModItems.WARLOCK_BOOTS);
        this.magicArmor(c, Items.field_151030_Z, (Item)ModItems.WARLOCK_CHESTPLATE);
        this.magicArmor(c, Items.field_151028_Y, (Item)ModItems.WARLOCK_HELMET);
        this.magicArmor(c, Items.field_151165_aa, (Item)ModItems.WARLOCK_LEGGINGS);
        this.magicArmor(c, Items.field_151021_T, (Item)ModItems.WIZARD_BOOTS);
        this.magicArmor(c, Items.field_151027_R, (Item)ModItems.WIZARD_CHESTPLATE);
        this.magicArmor(c, Items.field_151024_Q, (Item)ModItems.WIZARD_HAT);
        this.magicArmor(c, Items.field_151026_S, (Item)ModItems.WIZARD_LEGGINGS);
        c.accept(ModMagics.EGG_MAGIC.create().setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)new ResourceLocation("iceandfire", "fire_dragon"), (Object)new ResourceLocation("iceandfire", "ice_dragon"), (Object)new ResourceLocation("iceandfire", "lightning_dragon"))).setParams(200.0f, 40, this.ing(Items.field_151110_aK)), "");
        c.accept(ModMagics.ELYTRA_MAGIC.create().setParams(1.0f, -1, this.ing(Items.field_185160_cR)), "");
        c.accept(ModMagics.FEATHER_MAGIC.create().setParams(0.05f, -1, this.ing(Items.field_151008_G)), "");
        c.accept(ModMagics.GHAST_TEAR_MAGIC.create().setParams(0.5f, -1, this.ing(Items.field_151073_bk)), "");
        c.accept(ModMagics.GLOWSTONE_DUST_MAGIC.create().setParams(40.0f, 40, this.ing((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE)), "");
        c.accept(ModMagics.TRANSFORM_BLOCK_MAGIC.create().setAdditionalParams(Blocks.field_150348_b, Blocks.field_150352_o).setParams(50.0f, 25, this.ing((ITag<Item>)Tags.Items.INGOTS_GOLD)), "gold_magic");
        c.accept(ModMagics.GOLD_NUGGET_MAGIC.create().setParams(50.0f, 20, this.ing((ITag<Item>)Tags.Items.NUGGETS_GOLD)), "");
        c.accept(ModMagics.GRAPPLING_HOOK_MAGIC.create().setParams(5.0f, -1, this.ing(Items.field_151112_aM)), "");
        c.accept(ModMagics.JUKEBOX_MAGIC.create().setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)EntityType.field_200802_p.getRegistryName(), (Object)EntityType.field_200760_az.getRegistryName(), (Object)EntityType.field_200729_aH.getRegistryName()), 4.0f, SoundEvents.field_187842_ew).setParams(6.0f, -1, this.ing(Items.field_221778_cy)), "");
        c.accept(ModMagics.LODESTONE_MAGIC.create().setAdditionalParams(Blocks.field_235405_no_).setParams(500.0f, 120, this.ing(Items.field_234793_rv_)), "");
        c.accept(ModMagics.MAP_MAGIC.create().setParams(30.0f, 40, this.ing(Items.field_151148_bJ)), "");
        c.accept(ModMagics.MUSHROOM_CLOUD_MAGIC.create().setParams(50.0f, 40, this.ing(Items.field_221814_dq)), "");
        c.accept(ModMagics.NETHER_BRICK_MAGIC.create().setParams(60.0f, 20, this.ing((ITag<Item>)Tags.Items.INGOTS_NETHER_BRICK)), "");
        c.accept(ModMagics.TRANSMUTATION_MAGIC.create().setAdditionalParams(ModItems.NETHER_WIZARD_STAFF, ModSounds.POOF).setParams(100.0f, 40, this.ing((ITag<Item>)Tags.Items.INGOTS_NETHERITE)), "netherite_ingot_magic");
        c.accept(ModMagics.NETHERRACK_MAGIC.create().setParams(3.0f, -1, this.ing(Items.field_221691_cH)), "");
        c.accept(ModMagics.OBSIDIAN_MAGIC.create().setParams(100.0f, 60, this.ing(Items.field_221655_bP)), "");
        c.accept(ModMagics.PILLAR_MAGIC.create().setAdditionalParams(Blocks.field_150346_d).setParams(0.5f, -1, this.ing(Items.field_221582_j)), "");
        c.accept(ModMagics.PORTABLE_CRAFTING_MAGIC.create().setParams(10.0f, 10, this.ing(Items.field_221734_cc)), "");
        c.accept(ModMagics.POTION_MAGIC.create().setAdditionalParams(2, 600, 2.0f, Effects.field_76422_e, true, SoundEvents.field_187621_J).setParams(25.0f, 25, this.ing(Items.field_151039_o)), "");
        c.accept(ModMagics.SHULKER_BULLET_MAGIC.create().setParams(20.0f, 25, this.ing(Items.field_190930_cZ)), "");
        c.accept(ModMagics.SMELTING_MAGIC.create().setAdditionalParams((IRecipeType<? extends IRecipe<IInventory>>)IRecipeType.field_222150_b, 20, SoundEvents.field_187652_bv, Blocks.field_150460_al.func_149739_a()).setParams(1.0f, -1, this.ing(Items.field_221738_ce)), "");
        c.accept(ModMagics.SOUL_SAND_MAGIC.create().setParams(40.0f, 40, this.ing(Items.field_221693_cI)), "");
        c.accept(ModMagics.SMELTING_MAGIC.create().setAdditionalParams((IRecipeType<? extends IRecipe<IInventory>>)IRecipeType.field_222154_f, 2, SoundEvents.field_219719_ml, Blocks.field_222430_lS.func_149739_a()).setParams(0.1f, -1, this.ing(Items.field_222108_pO)), "stonecutting_magic");
        c.accept(ModMagics.SURFACE_MAGIC.create().setParams(0.5f, 20, this.ing(Items.field_221574_b)), "");
        c.accept(ModMagics.BUCKET_MAGIC.create().setAdditionalParams((BucketItem)Items.field_151131_as).setParams(5.0f, 10, this.ing(Items.field_151131_as)), "water_bucket_magic");
        c.accept(ModMagics.PROJECTILE_MAGIC.create().setAdditionalParams(ModEntities.MAGIC_WITHER_SKULL, ModSounds.SKELETON, 0.5f).setParams(20.0f, 15, this.ing(Items.field_196183_dw)), "wither_skull_magic");
        c.accept(ModMagics.PROJECTILE_MAGIC.create().setAdditionalParams(ModEntities.WIZARD_HAT, ModSounds.CLOTH, 1.0f).setParams(20.0f, 25, this.ing((Item)ModItems.WIZARD_HAT)), "wizard_hat_throw_magic");
        c.accept(ModMagics.WIZARD_STAFF_MAGIC.create().setParams(0.0f, 20, this.ing(ModItems.WIZARD_STAFF)), "");
        c.accept(ModMagics.WRITABLE_BOOK_MAGIC.create().setAdditionalParams((List<String>)ImmutableList.of((Object)"All that glitters is gold", (Object)"Fear the old blood", (Object)"Every fleeing man must be caught. Every secret must be unearthed. Such is the conceit of the self-proclaimed seeker of truth.", (Object)"What we do in life echoes in eternity", (Object)"STEVEN LIVES", (Object)"What we've got here is... failure to communicate", (Object)"All those moments will be lost in time, like tears in rain", (Object)"A wizard is never late, nor is he early. He arrives precisely when he means to.")).setParams(10.0f, 20, this.ing(Items.field_151099_bA)), "");
        c.accept(ModMagics.PUSH_BLOCK_MAGIC.create().setAdditionalParams(Blocks.field_150474_ac).setParams(15.0f, 25, this.ing(Items.field_221653_bO)), "push_spawner_magic");
        c.accept(ModMagics.REVERT_POSITION_MAGIC.create().setParams(15.0f, 15, this.ing(Items.field_185161_cS)), "");
        c.accept(ModMagics.REMOVE_FLUID_MAGIC.create().setAdditionalParams((Fluid)Fluids.field_204546_a).setParams(0.2f, 10, this.ing(Items.field_221646_ak)), "remove_water_magic");
        c.accept(ModMagics.PUSH_BUTTON_MAGIC.create().setParams(1.0f, -1, this.ing(Items.field_221766_cs)), "");
        c.accept(ModMagics.NAME_TAG_MAGIC.create().setAdditionalParams((List<String>)ImmutableList.of((Object)"ig", (Object)"nite", (Object)"syl", (Object)"la", (Object)"bles", (Object)"di", (Object)"vide", (Object)"un", (Object)"ex", (Object)"am", (Object)"ples", (Object)"dif", (Object[])new String[]{"fer", "ence", "re", "main", "der"})).setParams(10.0f, 20, this.ing(Items.field_151057_cb)), "");
        c.accept(ModMagics.LOCATE_SPAWN_MAGIC.create().setParams(25.0f, 20, this.ing(Items.field_151111_aL)), "");
        c.accept(ModMagics.TRANSFORM_ENTITY_MAGIC.create().setAdditionalParams(EntityType.field_200796_j, EntityType.field_200780_T, Helper.color(200, 100, 100, 255)).setParams(90.0f, 25, this.ing(Items.field_221692_bh)), "cow_to_mooshroom_magic");
        c.accept(ModMagics.INVENTORY_MAGIC.create().setParams(10.0f, 10, this.ing(Items.field_221675_bZ)), "");
        c.accept(ModMagics.ENDER_CHEST_MAGIC.create().setParams(10.0f, 10, this.ing(Items.field_221735_dD)), "");
        c.accept(ModMagics.DEFLECT_PROJECTILE_MAGIC.create().setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of()).setParams(0.8f, -1, this.ing(Items.field_185159_cQ)), "");
        c.accept(ModMagics.REPAIR_ARMOR_MAGIC.create().setAdditionalParams(1).setParams(1.0f, -1, this.ing(Items.field_221844_ef)), "");
        c.accept(ModMagics.SUMMON_ENTITY_MAGIC.create().setAdditionalParams(ModEntities.MAGIC_VEX, 3).setParams(40.0f, 40, this.ing(Items.field_190929_cY)), "summon_friendly_vex_magic");
        c.accept(ModMagics.MASS_HARVEST_MAGIC.create().setAdditionalParams(new BlockMatch((ITag.INamedTag<Block>)BlockTags.field_200031_h), 40).setParams(2.0f, 40, this.ing(Items.field_151056_x)), "chop_tree_magic");
        c.accept(ModMagics.MASS_HARVEST_MAGIC.create().setAdditionalParams(new BlockMatch((ITag.INamedTag<Block>)BlockTags.field_206952_E), 50).setParams(0.1f, 20, this.ing(Items.field_151097_aZ)), "clear_leaves_magic");
        c.accept(ModMagics.FORCE_ENTITY_MAGIC.create().setAdditionalParams(EntityType.field_200765_E, 0.2f).setParams(0.1f, -1, this.ing(Items.field_221698_bk)), "item_magnet_magic");
        c.accept(ModMagics.FORCE_ENTITY_MAGIC.create().setAdditionalParams(EntityType.field_200725_aD, -0.1f).setParams(0.5f, -1, this.ing(Items.field_151060_bw)), "repel_zombie_magic");
        c.accept(ModMagics.SWAP_POSITION_MAGIC.create().setAdditionalParams((Set<ResourceLocation>)ImmutableSet.of((Object)EntityType.field_200802_p.getRegistryName(), (Object)EntityType.field_200760_az.getRegistryName()), 5.0f).setParams(25.0f, 20, this.ing(Items.field_179565_cj)), "");
        c.accept(ModMagics.SWAP_HEALTH_FOOD_MAGIC.create().setParams(20.0f, 20, this.ing(Items.field_151083_be)), "");
        c.accept(ModMagics.SWAP_TRADE_MAGIC.create().setAdditionalParams(this.ing(Items.field_222109_pP)).setParams(400.0f, 40, this.ing(Items.field_151166_bC)), "");
    }

    private void magicArmor(BiConsumer<Magic, String> c, Item from, Item created) {
        c.accept(ModMagics.TRANSMUTATION_MAGIC.create().setAdditionalParams(created, ModSounds.PLOP).setParams(30.0f, 20, this.ing(from)), created.getRegistryName().func_110623_a() + "_fashion_magic");
    }

    private Ingredient ing(Item item) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item});
    }

    private Ingredient ing(ITag<Item> tag) {
        return Ingredient.func_199805_a(tag);
    }

    public String func_200397_b() {
        return "Magics";
    }
}

