/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import com.mojang.serialization.DynamicOps;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mod.vemerion.wizardstaff.entity.GrapplingHookEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

public class Wizard
implements INBTSerializable<CompoundNBT> {
    @CapabilityInject(value=Wizard.class)
    public static final Capability<Wizard> CAPABILITY = null;
    public static final int INVENTORY_SIZE = 27;
    private GlobalPos lodestonePos;
    private boolean lodestoneTracked;
    private GrapplingHookEntity grapplingHook;
    private BlockPos surfaceStart;
    private BlockPos surfaceStop;
    private LinkedList<GlobalPos> revertPositions = new LinkedList();
    private ItemStackHandler inventory = new ItemStackHandler(27);

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public static Wizard getWizard(PlayerEntity player) {
        return (Wizard)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalArgumentException("Player is missing wizard capability"));
    }

    public static LazyOptional<Wizard> getWizardOptional(PlayerEntity player) {
        return player.getCapability(CAPABILITY);
    }

    public void tick(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K && player.field_70173_aa % 20 == 0) {
            this.revertPositions.addFirst(GlobalPos.func_239648_a_((RegistryKey)player.field_70170_p.func_234923_W_(), (BlockPos)player.func_233580_cy_()));
            if (this.revertPositions.size() > 5) {
                this.revertPositions.removeLast();
            }
        }
    }

    public BlockPos revertPosition(PlayerEntity player) {
        if (this.revertPositions.size() < 5) {
            return null;
        }
        GlobalPos pos = this.revertPositions.getLast();
        return pos.func_239646_a_() == player.field_70170_p.func_234923_W_() ? pos.func_218180_b() : null;
    }

    public boolean lodestoneTeleport(ServerPlayerEntity player, Block waypoint) {
        if (this.lodestoneTracked && this.lodestonePos != null && player.field_70170_p.func_234923_W_() == this.lodestonePos.func_239646_a_() && player.field_70170_p.func_180495_p(this.lodestonePos.func_218180_b()).func_177230_c() == waypoint) {
            this.lodestoneTracked = false;
            BlockPos destination = this.lodestonePos.func_218180_b();
            player.func_200619_a(player.func_71121_q(), (double)destination.func_177958_n(), (double)(destination.func_177956_o() + 1), (double)destination.func_177952_p(), player.field_70177_z, player.field_70125_A);
            player.field_70170_p.func_175655_b(destination, false);
            return true;
        }
        return false;
    }

    public boolean throwGrapplingHook(World world, PlayerEntity player) {
        Vector3d end;
        Vector3d start;
        BlockRayTraceResult raytrace;
        if (!world.field_72995_K && (raytrace = world.func_217299_a(new RayTraceContext(start = player.func_174824_e(0.5f), end = start.func_178787_e(Vector3d.func_189984_a((Vector2f)player.func_189653_aC()).func_186678_a(10.0)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player))).func_216346_c() == RayTraceResult.Type.BLOCK) {
            GrapplingHookEntity hook = new GrapplingHookEntity(world, player);
            Vector3d pos = raytrace.func_216347_e().func_178788_d(end.func_178788_d(start).func_72432_b().func_186678_a(0.07));
            hook.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player.field_70177_z, player.field_70125_A);
            world.func_217376_c((Entity)hook);
            this.grapplingHook = hook;
            return true;
        }
        return false;
    }

    public void trackLodestone(World world, BlockPos pos, Block waypoint) {
        if (world.func_180495_p(pos).func_177230_c() == waypoint) {
            this.lodestoneTracked = true;
            this.lodestonePos = GlobalPos.func_239648_a_((RegistryKey)world.func_234923_W_(), (BlockPos)pos.func_185334_h());
        }
    }

    public void reelGrapplingHook(World world, PlayerEntity player) {
        if (this.grapplingHook != null && this.grapplingHook.func_70089_S()) {
            Vector3d direction = this.grapplingHook.func_213303_ch().func_178788_d(player.func_213303_ch()).func_72432_b().func_186678_a(1.2);
            Vector3d motion = player.func_213322_ci().func_178787_e(direction);
            player.func_213317_d(motion);
            if (!world.field_72995_K) {
                this.grapplingHook.func_70106_y();
            }
        }
    }

    public void setGrapplingHook(GrapplingHookEntity hook) {
        this.grapplingHook = hook;
    }

    public void setSurfacePos(BlockPos pos) {
        if (pos.equals((Object)this.surfaceStart)) {
            this.surfaceStart = null;
        } else if (pos.equals((Object)this.surfaceStop)) {
            this.surfaceStop = null;
        } else if (this.surfaceStart != null && this.surfaceStop != null) {
            this.surfaceStart = pos;
            this.surfaceStop = null;
        } else if (this.surfaceStart == null) {
            this.surfaceStart = pos;
        } else {
            this.surfaceStop = pos;
        }
    }

    public int createSurface(World world, PlayerEntity player) {
        BlockPos start = this.surfaceStart == null ? null : new BlockPos((Vector3i)this.surfaceStart);
        BlockPos stop = this.surfaceStop == null ? null : new BlockPos((Vector3i)this.surfaceStop);
        this.surfaceStart = null;
        this.surfaceStop = null;
        if (start == null || stop == null) {
            return 0;
        }
        if (!player.func_233580_cy_().func_218141_a((Vector3i)start, 100.0) || !player.func_233580_cy_().func_218141_a((Vector3i)stop, 100.0)) {
            return 0;
        }
        if (world.func_175623_d(start) || world.func_175623_d(stop)) {
            return 0;
        }
        AxisAlignedBB surface = new AxisAlignedBB(start, stop);
        if (surface.func_216364_b() > 0.1 && surface.func_216360_c() > 0.1 && surface.func_216362_d() > 0.1) {
            return 0;
        }
        Item item = world.func_180495_p(start).func_177230_c().func_199767_j();
        if (item == Items.field_190931_a || !(item instanceof BlockItem)) {
            return 0;
        }
        List positions = BlockPos.func_239581_a_((AxisAlignedBB)surface).map(b -> b.func_185334_h()).collect(Collectors.toList());
        int count = 0;
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_77973_b() != item) continue;
            ItemStack stack = inv.func_70304_b(i);
            while (!positions.isEmpty() && !stack.func_190926_b()) {
                DirectionalPlaceContext context;
                BlockPos p = (BlockPos)positions.remove(0);
                if (!world.func_175623_d(p) || ((BlockItem)item).func_195942_a((BlockItemUseContext)(context = new DirectionalPlaceContext(world, p, Direction.NORTH, stack, Direction.DOWN))) == ActionResultType.FAIL) continue;
                ++count;
            }
            inv.func_70441_a(stack);
        }
        return count;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.lodestoneTracked = compound.func_74767_n("lodestoneTracked");
        if (this.lodestoneTracked) {
            this.lodestonePos = GlobalPos.field_239645_a_.parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("lodestonePos")).result().orElse(null);
        }
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        if (this.lodestoneTracked) {
            GlobalPos.field_239645_a_.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.lodestonePos).resultOrPartial(s -> {}).ifPresent(lodestonePos -> compound.func_218657_a("lodestonePos", lodestonePos));
        }
        compound.func_74757_a("lodestoneTracked", this.lodestoneTracked);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        return compound;
    }

    public static class WizardStorage
    implements Capability.IStorage<Wizard> {
        public INBT writeNBT(Capability<Wizard> capability, Wizard instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<Wizard> capability, Wizard instance, Direction side, INBT nbt) {
            instance.deserializeNBT((CompoundNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="wizard-staff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WizardProvider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<Wizard> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());
        public static final ResourceLocation LOCATION = new ResourceLocation("wizard-staff", "wizard");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(LOCATION, (ICapabilityProvider)new WizardProvider());
            }
        }
    }
}

