/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.capability;

import java.util.function.Supplier;
import mod.vemerion.wizardstaff.network.Network;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class ScreenAnimations
implements INBTSerializable<ByteNBT> {
    @CapabilityInject(value=ScreenAnimations.class)
    public static final Capability<ScreenAnimations> CAPABILITY = null;
    private boolean shouldAnimate;

    public ScreenAnimations() {
        this.shouldAnimate = true;
    }

    public ScreenAnimations(boolean shouldAnimate) {
        this.shouldAnimate = shouldAnimate;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    public void setShouldAnimate(boolean value) {
        this.shouldAnimate = value;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.shouldAnimate);
    }

    public static ScreenAnimations decode(PacketBuffer buffer) {
        return new ScreenAnimations(buffer.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.setPacketHandled(true);
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player != null) {
                ScreenAnimations screenAnimations = ScreenAnimations.getScreenAnimations((PlayerEntity)player);
                screenAnimations.setShouldAnimate(this.shouldAnimate);
            }
        });
    }

    public static void sendMessage(PlayerEntity player, boolean shouldAnimate) {
        Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ScreenAnimations(shouldAnimate));
    }

    public static ScreenAnimations getScreenAnimations(PlayerEntity player) {
        return (ScreenAnimations)player.getCapability(CAPABILITY).orElse((Object)new ScreenAnimations());
    }

    public ByteNBT serializeNBT() {
        return ByteNBT.func_229672_a_((boolean)this.shouldAnimate);
    }

    public void deserializeNBT(ByteNBT nbt) {
        this.shouldAnimate = nbt.func_150290_f() == 1;
    }

    public static class ScreenAnimationsStorage
    implements Capability.IStorage<ScreenAnimations> {
        public INBT writeNBT(Capability<ScreenAnimations> capability, ScreenAnimations instance, Direction side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<ScreenAnimations> capability, ScreenAnimations instance, Direction side, INBT nbt) {
            instance.deserializeNBT((ByteNBT)nbt);
        }
    }

    @Mod.EventBusSubscriber(modid="wizard-staff", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ScreenAnimationsProvider
    implements ICapabilitySerializable<INBT> {
        private LazyOptional<ScreenAnimations> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());
        public static final ResourceLocation SCREEN_ANIMATIONS_LOCATION = new ResourceLocation("wizard-staff", "screenanimations");

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return CAPABILITY.orEmpty(cap, this.instance);
        }

        public INBT serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
        }

        public void deserializeNBT(INBT nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, nbt);
        }

        @SubscribeEvent
        public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(SCREEN_ANIMATIONS_LOCATION, (ICapabilityProvider)new ScreenAnimationsProvider());
            }
        }
    }
}

