/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class SwapTradeMagic
extends RayMagic {
    private Ingredient blacklist = Ingredient.field_193370_a;

    public SwapTradeMagic(MagicType<? extends SwapTradeMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    @Override
    protected IParticleData generateParticle(World world, PlayerEntity player, ItemStack staff, int count) {
        return ParticleTypes.field_197632_y;
    }

    public SwapTradeMagic setAdditionalParams(Ingredient blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"blacklist_ingredient")) {
            this.blacklist = Ingredient.func_199802_a((JsonElement)json.get("blacklist_ingredient"));
        }
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        if (this.blacklist != Ingredient.field_193370_a) {
            json.add("blacklist_ingredient", this.blacklist.func_200304_c());
        }
    }

    @Override
    protected void hitEntity(World world, PlayerEntity player, Entity target) {
        if (!(target instanceof VillagerEntity)) {
            this.playSoundServer(world, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        VillagerEntity villager = (VillagerEntity)target;
        this.cost(player);
        MerchantOffers offers = new MerchantOffers();
        for (MerchantOffer offer : villager.func_213706_dY()) {
            ItemStack buyFirst = offer.func_222218_a();
            ItemStack buySecond = offer.func_222202_c();
            ItemStack sell = offer.func_222200_d();
            if (this.isBlacklisted(buyFirst) || this.isBlacklisted(buySecond) || this.isBlacklisted(sell) || !buyFirst.func_190926_b() && !buySecond.func_190926_b()) {
                offers.add((Object)new MerchantOffer(offer.func_222208_r()));
                continue;
            }
            ItemStack selling = (buyFirst.func_190926_b() ? buySecond : buyFirst).func_77946_l();
            offers.add((Object)new MerchantOffer(sell.func_77946_l(), ItemStack.field_190927_a, selling, offer.func_222214_i(), offer.func_222214_i(), offer.func_222210_n(), offer.func_222211_m(), offer.func_225482_k()));
        }
        villager.func_213768_b(offers);
        this.playSoundServer(world, player, SoundEvents.field_219721_mv, 1.0f, this.soundPitch(player));
    }

    private boolean isBlacklisted(ItemStack stack) {
        return !stack.func_190926_b() && this.blacklist.test(stack);
    }
}

