/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SwapPositionMagic
extends RayMagic {
    private Set<ResourceLocation> blacklist;
    private float range;

    public SwapPositionMagic(MagicType<? extends SwapPositionMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public SwapPositionMagic setAdditionalParams(Set<ResourceLocation> blacklist, float range) {
        this.blacklist = blacklist;
        this.range = range;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)e, (String)"entity name")), new HashSet());
        this.range = JSONUtils.func_151217_k((JsonObject)json, (String)"range");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, r -> new JsonPrimitive(r.toString()));
        json.addProperty("range", (Number)Float.valueOf(this.range));
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        buffer.writeFloat(this.range);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.range = buffer.readFloat();
    }

    @Override
    protected float getRange() {
        return this.range;
    }

    @Override
    protected IParticleData generateParticle(World world, PlayerEntity player, ItemStack staff, int count) {
        Random rand = player.func_70681_au();
        float duration = this.getUseDuration(staff);
        float progress = (duration - (float)count) / duration;
        float alfa = Math.min(1.0f, progress * 1.5f);
        return new MagicDustParticleData(0.9f + rand.nextFloat() * 0.1f, 0.9f + rand.nextFloat() * 0.1f, 0.0f, alfa);
    }

    @Override
    protected void hitEntity(World world, PlayerEntity player, Entity target) {
        if (!(target instanceof LivingEntity) || this.blacklist.contains(target.func_200600_R().getRegistryName())) {
            this.playSoundServer(world, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        this.cost(player);
        Vector3d start = player.func_213303_ch();
        player.func_70634_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        target.func_70634_a(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.playSoundServer(world, player, ModSounds.SWAP, 1.0f, this.soundPitch(player));
    }
}

