/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.BlockMatch;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class MassHarvestMagic
extends Magic {
    private BlockMatch match;
    private int harvestLimit;

    public MassHarvestMagic(MagicType<? extends MassHarvestMagic> type) {
        super(type);
    }

    public MassHarvestMagic setAdditionalParams(BlockMatch match, int harvestLimit) {
        this.match = match;
        this.harvestLimit = harvestLimit;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.match = BlockMatch.read(JSONUtils.func_152754_s((JsonObject)json, (String)"block_match"));
        this.harvestLimit = JSONUtils.func_151203_m((JsonObject)json, (String)"harvest_limit");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.add("block_match", (JsonElement)this.match.write());
        json.addProperty("harvest_limit", (Number)this.harvestLimit);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        this.match.encode(buffer);
        buffer.writeInt(this.harvestLimit);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.match = BlockMatch.decode(buffer);
        this.harvestLimit = buffer.readInt();
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::drill;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.match.getName()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new StringTextComponent(String.valueOf(this.harvestLimit)), this.match.getName()};
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        BlockRayTraceResult result = Helper.blockRay(world, player, 4.0f);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockState state = world.func_180495_p(result.func_216350_a());
            if (this.match.test(state.func_177230_c())) {
                player.func_184185_a(state.func_215695_r().func_185845_c(), 1.0f, this.soundPitch(player));
                if (!world.field_72995_K) {
                    this.cost(player, this.havestBlocks(result.func_216350_a(), world));
                }
            } else {
                player.func_184185_a(ModSounds.POOF, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(world, player, staff);
    }

    private int havestBlocks(BlockPos start, World world) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        HashSet found = new HashSet();
        positions.add(start);
        while (!positions.isEmpty()) {
            BlockPos pos = (BlockPos)positions.remove(0);
            BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1)).forEach(p -> {
                if (found.size() < this.harvestLimit && !found.contains(p) && this.match.test(world.func_180495_p(p).func_177230_c())) {
                    BlockPos immutable = p.func_185334_h();
                    positions.add(immutable);
                    found.add(immutable);
                }
            });
            this.destroyBlock(world, pos);
        }
        return found.size();
    }

    private void destroyBlock(World world, BlockPos pos) {
        FluidState fluidstate = world.func_204610_c(pos);
        BlockState state = world.func_180495_p(pos);
        TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tileentity, null, (ItemStack)ItemStack.field_190927_a);
        world.func_175656_a(pos, fluidstate.func_206883_i());
    }
}

