/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.swap;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ForceEntityMagic
extends Magic {
    private float force;
    private EntityType<?> type;

    public ForceEntityMagic(MagicType<? extends ForceEntityMagic> type) {
        super(type);
    }

    public ForceEntityMagic setAdditionalParams(EntityType<?> type, float force) {
        this.type = type;
        this.force = force;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.type = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "entity");
        this.force = JSONUtils.func_151217_k((JsonObject)json, (String)"force");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.type, "entity");
        json.addProperty("force", (Number)Float.valueOf(this.force));
    }

    @Override
    public void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.type);
        buffer.writeFloat(this.force);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.type = (EntityType)MagicUtil.decode(buffer, ForgeRegistries.ENTITIES);
        this.force = buffer.readFloat();
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.force >= 0.0f ? new TranslationTextComponent("gui.wizard-staff." + ModMagics.FORCE_ENTITY_MAGIC.getRegistryName().func_110623_a() + ".attract") : new TranslationTextComponent("gui.wizard-staff." + ModMagics.FORCE_ENTITY_MAGIC.getRegistryName().func_110623_a() + ".repel"), this.type.func_212546_e()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::circling;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
        for (Entity e2 : world.func_217394_a(this.type, player.func_174813_aQ().func_186662_g(3.0), e -> true)) {
            Vector3d motion = player.func_213303_ch().func_178788_d(e2.func_213303_ch()).func_72432_b().func_186678_a((double)this.force).func_216372_d(1.0, 0.0, 1.0).func_72441_c(0.0, e2.func_213322_ci().field_72448_b, 0.0);
            e2.func_213317_d(motion);
        }
        if (!world.field_72995_K) {
            this.cost(player);
        }
        if (count % 6 == 0) {
            player.func_184185_a(ModSounds.MAGNET, 1.0f, this.soundPitch(player));
        }
    }
}

