/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class TransformEntityMagic
extends RayMagic {
    private EntityType<?> from;
    private EntityType<?> to;
    private int particleColor;
    private Vector4f particleColorComponents;

    public TransformEntityMagic(MagicType<? extends TransformEntityMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public TransformEntityMagic setAdditionalParams(EntityType<?> from, EntityType<?> to, int particleColor) {
        this.from = from;
        this.to = to;
        this.particleColor = particleColor;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.from, "from");
        MagicUtil.write(json, this.to, "to");
        json.addProperty("particle_color", (Number)this.particleColor);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.from = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "from");
        this.to = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "to");
        this.particleColor = JSONUtils.func_151203_m((JsonObject)json, (String)"particle_color");
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.from);
        MagicUtil.encode(buffer, this.to);
        buffer.writeInt(this.particleColor);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.from = (EntityType)MagicUtil.decode(buffer, ForgeRegistries.ENTITIES);
        this.to = (EntityType)MagicUtil.decode(buffer, ForgeRegistries.ENTITIES);
        this.particleColor = buffer.readInt();
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.from.func_212546_e(), this.to.func_212546_e()};
    }

    @Override
    protected IParticleData generateParticle(World world, PlayerEntity player, ItemStack staff, int count) {
        if (this.particleColorComponents == null) {
            this.particleColorComponents = new Vector4f((float)Helper.red(this.particleColor) / 255.0f, (float)Helper.green(this.particleColor) / 255.0f, (float)Helper.blue(this.particleColor) / 255.0f, (float)Helper.alfa(this.particleColor) / 255.0f);
        }
        return new MagicDustParticleData(this.particleColorComponents.func_195910_a(), this.particleColorComponents.func_195913_b(), this.particleColorComponents.func_195914_c(), this.particleColorComponents.func_195915_d());
    }

    @Override
    protected void hitEntity(World world, PlayerEntity player, Entity target) {
        if (target.func_200600_R() == this.from) {
            this.playSoundServer(world, player, ModSounds.TRANSFORM, 0.7f, this.soundPitch(player));
            if (!world.field_72995_K) {
                this.cost(player);
                Entity entity = this.to.func_200721_a(world);
                if (target.func_145818_k_()) {
                    entity.func_200203_b(target.func_200201_e());
                }
                entity.func_70080_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                world.func_217376_c(entity);
                target.func_70106_y();
            }
        }
    }
}

