/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.entity.MagicVexEntity;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class SummonEntityMagic
extends Magic {
    private EntityType<?> entity;
    private int count;

    public SummonEntityMagic(MagicType<? extends SummonEntityMagic> type) {
        super(type);
    }

    public SummonEntityMagic setAdditionalParams(EntityType<?> entity, int count) {
        this.entity = entity;
        this.count = count;
        return this;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.entity, "entity");
        json.addProperty("count", (Number)this.count);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.entity = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "entity");
        this.count = JSONUtils.func_151203_m((JsonObject)json, (String)"count");
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.entity);
        buffer.writeInt(this.count);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.entity = (EntityType)MagicUtil.decode(buffer, ForgeRegistries.ENTITIES);
        this.count = buffer.readInt();
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.CROSSBOW;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.entity.func_212546_e()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new StringTextComponent(String.valueOf(this.count)), this.entity.func_212546_e()};
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            this.cost(player);
            for (int i = 0; i < this.count; ++i) {
                Entity e = this.entity.func_200721_a(world);
                Vector3d pos = this.nearby(player);
                e.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player.func_70681_au().nextFloat() * 360.0f, 0.0f);
                if (e instanceof MagicVexEntity) {
                    MagicVexEntity vex = (MagicVexEntity)e;
                    vex.setCaster(player);
                    vex.func_190653_a(400);
                }
                world.func_217376_c(e);
            }
        }
        player.func_184185_a(ModSounds.BELL, 1.0f, this.soundPitch(player));
        return super.magicFinish(world, player, staff);
    }

    private Vector3d nearby(PlayerEntity player) {
        return player.func_213303_ch().func_72441_c(this.randCoord(player), this.randCoord(player) + 1.0, this.randCoord(player));
    }

    private double randCoord(PlayerEntity player) {
        return (player.func_70681_au().nextDouble() - 0.5) * 2.0;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::buildup;
    }
}

