/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RemoveFluidMagic
extends Magic {
    private Fluid fluid;

    public RemoveFluidMagic(MagicType<?> type) {
        super(type);
    }

    public RemoveFluidMagic setAdditionalParams(Fluid fluid) {
        this.fluid = fluid;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.fluid = (Fluid)MagicUtil.read(json, ForgeRegistries.FLUIDS, "fluid");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.fluid, "fluid");
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.fluid);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.fluid = (Fluid)MagicUtil.decode(buffer, ForgeRegistries.FLUIDS);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::circling;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{new StringTextComponent(this.fluid.getRegistryName().func_110623_a())};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            int count = 0;
            BlockPos pos = player.func_233580_cy_();
            for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
                BlockState blockstate = world.func_180495_p(p);
                Block block = blockstate.func_177230_c();
                if (!blockstate.func_204520_s().func_206886_c().func_207187_a(this.fluid) || !(block instanceof IBucketPickupHandler) || ((IBucketPickupHandler)block).func_204508_a((IWorld)world, p, blockstate) == Fluids.field_204541_a) continue;
                ++count;
            }
            this.cost(player, count);
            if (count > 0) {
                this.playSoundServer(world, player, ModSounds.EVAPORATE, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(world, player, staff);
    }
}

