/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions2;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class PushBlockMagic
extends Magic {
    private static final int MAX_DISTANCE = 10;
    private Block block;

    public PushBlockMagic(MagicType<? extends PushBlockMagic> type) {
        super(type);
    }

    public PushBlockMagic setAdditionalParams(Block block) {
        this.block = block;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.block = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "block");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.block, "block");
    }

    @Override
    public void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.block);
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.block = (Block)MagicUtil.decode(buffer, ForgeRegistries.BLOCKS);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardBuildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.block.func_235333_g_()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return this.getNameArgs();
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            Direction direction = Direction.func_196054_a((Entity)player)[0];
            BlockPos start = this.ray(world, player);
            if (start != null) {
                BlockPos p = new BlockPos((Vector3i)start);
                BlockState state = world.func_180495_p(p);
                TileEntity tileEntity = world.func_175625_s(start);
                if (tileEntity != null) {
                    tileEntity = TileEntity.func_235657_b_((BlockState)state, (CompoundNBT)tileEntity.serializeNBT());
                }
                for (int i = 0; i < 10 && world.func_175623_d(p.func_177972_a(direction)) && state.func_196955_c((IWorldReader)world, p.func_177972_a(direction)); ++i) {
                    p = p.func_177972_a(direction);
                }
                if (p.equals((Object)start)) {
                    this.playSoundServer(world, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
                } else {
                    this.playSoundServer(world, player, ModSounds.PUSH, 1.0f, this.soundPitch(player));
                    this.cost(player);
                    world.func_175656_a(p, state);
                    if (tileEntity != null) {
                        world.func_175713_t(start);
                        tileEntity.func_174878_a(p);
                        world.func_175690_a(p, tileEntity);
                        tileEntity.func_70296_d();
                    }
                    world.func_175656_a(start, Blocks.field_150350_a.func_176223_P());
                }
            } else {
                this.playSoundServer(world, player, ModSounds.POOF, 1.0f, this.soundPitch(player));
            }
        }
        return super.magicFinish(world, player, staff);
    }

    private BlockPos ray(World world, PlayerEntity player) {
        BlockRayTraceResult result = Helper.blockRay(world, player, 5.0f);
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(result.func_216350_a()).func_177230_c() == this.block) {
            return result.func_216350_a();
        }
        return null;
    }
}

