/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.suggestions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketMagic
extends Magic {
    private BucketItem bucket;

    public BucketMagic(MagicType<? extends BucketMagic> type) {
        super(type);
    }

    public BucketMagic setAdditionalParams(BucketItem bucket) {
        this.bucket = bucket;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardWaving;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        Item item = (Item)MagicUtil.read(json, ForgeRegistries.ITEMS, "bucket");
        if (!(item instanceof BucketItem)) {
            throw new JsonParseException("bucket attribute must be instance of BucketItem");
        }
        this.bucket = (BucketItem)item;
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.bucket, "bucket");
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.bucket = (BucketItem)MagicUtil.decode(buffer, ForgeRegistries.ITEMS);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.bucket);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.bucket.func_200295_i(this.bucket.func_190903_i())};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.bucket.func_200295_i(this.bucket.func_190903_i())};
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        BlockPos pos;
        Vector3d end;
        Vector3d start = player.func_174824_e(1.0f);
        BlockRayTraceResult raytrace = world.func_217299_a(new RayTraceContext(start, end = start.func_178787_e(Vector3d.func_189984_a((Vector2f)player.func_189653_aC()).func_186678_a(4.5)), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (raytrace.func_216346_c() == RayTraceResult.Type.BLOCK && this.bucket.func_180616_a(player, world, pos = new BlockPos(raytrace.func_216347_e()), raytrace)) {
            this.bucket.func_203792_a(world, new ItemStack((IItemProvider)this.bucket), pos);
            if (!world.field_72995_K) {
                this.cost(player);
            }
        }
        return super.magicFinish(world, player, staff);
    }
}

