/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class SmeltingMagic
extends Magic {
    private IRecipeType<? extends IRecipe<IInventory>> recipeType;
    private int interval;
    private SoundEvent sound;
    private String recipeName;

    public SmeltingMagic(MagicType<? extends SmeltingMagic> type) {
        super(type);
    }

    public SmeltingMagic setAdditionalParams(IRecipeType<? extends IRecipe<IInventory>> recipeType, int interval, SoundEvent sound, String recipeName) {
        this.recipeType = recipeType;
        this.interval = interval;
        this.sound = sound;
        this.recipeName = recipeName;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::spinMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.recipeType = (IRecipeType)MagicUtil.decode(buffer, Registry.field_218367_H);
        this.sound = (SoundEvent)MagicUtil.decode(buffer, ForgeRegistries.SOUND_EVENTS);
        this.interval = buffer.readInt();
        int nameLength = buffer.readInt();
        this.recipeName = buffer.func_150789_c(nameLength);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.recipeType, Registry.field_218367_H);
        MagicUtil.encode(buffer, this.sound);
        buffer.writeInt(this.interval);
        buffer.writeInt(this.recipeName.length());
        buffer.func_180714_a(this.recipeName);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.recipeType = (IRecipeType)MagicUtil.read(json, Registry.field_218367_H, "recipe_type");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
        this.interval = JSONUtils.func_151203_m((JsonObject)json, (String)"smelt_interval");
        this.recipeName = JSONUtils.func_151200_h((JsonObject)json, (String)"recipe_name");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.recipeType, Registry.field_218367_H, "recipe_type");
        MagicUtil.write(json, this.sound, "sound");
        json.addProperty("smelt_interval", (Number)this.interval);
        json.addProperty("recipe_name", this.recipeName);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{new TranslationTextComponent(this.recipeName)};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new TranslationTextComponent(this.recipeName)};
    }

    @Override
    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
        if (!world.field_72995_K && count % this.interval == 0 && count != this.getUseDuration(staff)) {
            Random rand = player.func_70681_au();
            List entities = world.func_175647_a(ItemEntity.class, player.func_174813_aQ().func_186662_g(2.0), e -> !this.getRecipes(world, (ItemEntity)e).isEmpty());
            if (entities.isEmpty()) {
                return;
            }
            ItemEntity itemEntity = (ItemEntity)entities.get(rand.nextInt(entities.size()));
            Inventory inv = new Inventory(new ItemStack[]{itemEntity.func_92059_d()});
            List recipes = world.func_199532_z().func_215370_b(this.recipeType, (IInventory)inv, world);
            if (!recipes.isEmpty()) {
                this.playSoundServer(world, player, this.sound, 1.0f, this.soundPitch(player));
                this.cost(player);
                IRecipe recipe = (IRecipe)recipes.get(rand.nextInt(recipes.size()));
                itemEntity.func_92059_d().func_190918_g(this.getRecipeCost((IRecipe<IInventory>)recipe));
                itemEntity.func_199701_a_(recipe.func_77572_b((IInventory)inv));
            }
        }
    }

    private List<? extends IRecipe<IInventory>> getRecipes(World world, ItemEntity itemEntity) {
        Inventory inv = new Inventory(new ItemStack[]{itemEntity.func_92059_d()});
        return world.func_199532_z().func_215370_b(this.recipeType, (IInventory)inv, world);
    }

    private int getRecipeCost(IRecipe<IInventory> recipe) {
        int cost = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            for (ItemStack stack : ingredient.func_193365_a()) {
                cost += stack.func_190916_E();
            }
        }
        return cost;
    }
}

