/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.restructuring;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMagic
extends Magic {
    private int level;
    private int potionTime;
    private float radius;
    private Effect potion;
    private boolean affectCaster;
    private SoundEvent sound;

    public PotionMagic(MagicType<? extends PotionMagic> type) {
        super(type);
    }

    public PotionMagic setAdditionalParams(int level, int potionTime, float radius, Effect potion, boolean affectCaster, SoundEvent sound) {
        this.level = level;
        this.potionTime = potionTime;
        this.radius = radius;
        this.potion = potion;
        this.affectCaster = affectCaster;
        this.sound = sound;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.level = JSONUtils.func_151203_m((JsonObject)json, (String)"level");
        this.potionTime = JSONUtils.func_151203_m((JsonObject)json, (String)"potion_time");
        this.radius = JSONUtils.func_151217_k((JsonObject)json, (String)"radius");
        this.potion = (Effect)MagicUtil.read(json, ForgeRegistries.POTIONS, "potion");
        this.affectCaster = JSONUtils.func_151212_i((JsonObject)json, (String)"affect_caster");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        json.addProperty("level", (Number)this.level);
        json.addProperty("potion_time", (Number)this.potionTime);
        json.addProperty("radius", (Number)Float.valueOf(this.radius));
        MagicUtil.write(json, this.potion, "potion");
        json.addProperty("affect_caster", Boolean.valueOf(this.affectCaster));
        MagicUtil.write(json, this.sound, "sound");
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.level = buffer.readInt();
        this.potionTime = buffer.readInt();
        this.radius = buffer.readFloat();
        this.potion = (Effect)MagicUtil.decode(buffer, ForgeRegistries.POTIONS);
        this.affectCaster = buffer.readBoolean();
        this.sound = (SoundEvent)MagicUtil.decode(buffer, ForgeRegistries.SOUND_EVENTS);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        buffer.writeInt(this.level);
        buffer.writeInt(this.potionTime);
        buffer.writeFloat(this.radius);
        MagicUtil.encode(buffer, this.potion);
        buffer.writeBoolean(this.affectCaster);
        MagicUtil.encode(buffer, this.sound);
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.potion.func_199286_c(), this.levelTranslation()};
    }

    @Override
    protected Object[] getDescrArgs() {
        Object[] args = new Object[5];
        args[0] = this.potion.func_199286_c();
        args[1] = this.levelTranslation();
        args[2] = new StringTextComponent(String.valueOf(this.potionTime / 20));
        ITextComponent glue = (double)this.radius > 0.001 ? new TranslationTextComponent("gui.wizard-staff.potion_magic.glue") : StringTextComponent.field_240750_d_;
        args[3] = this.affectCaster ? new TranslationTextComponent("gui.wizard-staff.potion_magic.affect_caster", new Object[]{glue}) : StringTextComponent.field_240750_d_;
        args[4] = (double)this.radius > 0.001 ? new TranslationTextComponent("gui.wizard-staff.potion_magic.affect_others") : StringTextComponent.field_240750_d_;
        return args;
    }

    private TextComponent levelTranslation() {
        if (this.level <= 0) {
            return new TranslationTextComponent("enchantment.level.1");
        }
        if (this.level <= 10) {
            return new TranslationTextComponent("enchantment.level." + this.level);
        }
        return new StringTextComponent(String.valueOf(this.level));
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            this.cost(player);
            if (this.affectCaster) {
                player.func_195064_c(new EffectInstance(this.potion, this.potionTime, this.level - 1));
            }
            if ((double)this.radius > 0.001) {
                AxisAlignedBB box = new AxisAlignedBB(player.func_213303_ch(), player.func_213303_ch()).func_186662_g((double)this.radius);
                for (LivingEntity e2 : world.func_175647_a(LivingEntity.class, box, e -> e != player)) {
                    e2.func_195064_c(new EffectInstance(this.potion, this.potionTime, this.level - 1));
                }
            }
        }
        player.func_184185_a(this.sound, 1.0f, this.soundPitch(player));
        return super.magicFinish(world, player, staff);
    }
}

