/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import mod.vemerion.wizardstaff.staff.WizardStaffItemHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.world.World;

public class WritableBookMagic
extends Magic {
    private List<String> wisdoms;

    public WritableBookMagic(MagicType<? extends WritableBookMagic> type) {
        super(type);
    }

    public WritableBookMagic setAdditionalParams(List<String> wisdoms) {
        this.wisdoms = wisdoms;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.wisdoms = MagicUtil.readColl(json, "wisdoms", e -> JSONUtils.func_151206_a((JsonElement)e, (String)"wisdom"), new ArrayList());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "wisdoms", this.wisdoms, JsonPrimitive::new);
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        String wisdom = this.wisdoms.get(player.func_70681_au().nextInt(this.wisdoms.size()));
        player.func_184185_a(ModSounds.SCRIBBLE, 1.0f, this.soundPitch(player));
        if (!world.field_72995_K) {
            WizardStaffItemHandler.getOptional(staff).ifPresent(h -> {
                this.cost(player);
                ItemStack book = h.extractCurrent();
                CompoundNBT tag = book.func_196082_o();
                ListNBT pages = new ListNBT();
                pages.add((Object)StringNBT.func_229705_a_((String)wisdom));
                tag.func_218657_a("pages", (INBT)pages);
                book = new ItemStack((IItemProvider)Items.field_151099_bA);
                book.func_77982_d(tag);
                h.insertCurrent(book);
            });
        }
        return super.magicFinish(world, player, staff);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::buildupMagic;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::spinMagic;
    }
}

