/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class TransformBlockMagic
extends Magic {
    private Block from;
    private Block to;

    public TransformBlockMagic(MagicType<? extends TransformBlockMagic> type) {
        super(type);
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public TransformBlockMagic setAdditionalParams(Block from, Block to) {
        this.from = from;
        this.to = to;
        return this;
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.from = (Block)MagicUtil.decode(buffer, ForgeRegistries.BLOCKS);
        this.to = (Block)MagicUtil.decode(buffer, ForgeRegistries.BLOCKS);
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.from);
        MagicUtil.encode(buffer, this.to);
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.from = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "from");
        this.to = (Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "to");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.from, "from");
        MagicUtil.write(json, this.to, "to");
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.from.func_235333_g_(), this.to.func_235333_g_()};
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.from.func_235333_g_(), this.to.func_235333_g_()};
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            Vector3d stop;
            Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC());
            Vector3d start = player.func_213303_ch().func_72441_c(0.0, 1.5, 0.0).func_178787_e(direction.func_186678_a(0.2));
            BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(start, stop = start.func_178787_e(direction.func_186678_a(4.5)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(result.func_216350_a()).func_177230_c() == this.from) {
                BlockPos pos = result.func_216350_a();
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187835_fT, SoundCategory.PLAYERS, 1.5f, this.soundPitch(player));
                this.cost(player);
                world.func_175656_a(pos, this.to.func_176223_P());
            }
        }
        return super.magicFinish(world, player, staff);
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardBuildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }
}

