/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.network.JukeboxMagicMessage;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class JukeboxMagic
extends Magic {
    private Set<ResourceLocation> blacklist;
    private float range;
    private SoundEvent music;

    public JukeboxMagic(MagicType<? extends JukeboxMagic> type) {
        super(type);
    }

    public JukeboxMagic setAdditionalParams(Set<ResourceLocation> blacklist, float range, SoundEvent music) {
        this.blacklist = blacklist;
        this.range = range;
        this.music = music;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)e, (String)"entity name")), new HashSet());
        this.range = JSONUtils.func_151217_k((JsonObject)json, (String)"range");
        this.music = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "music");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, rl -> new JsonPrimitive(rl.toString()));
        json.addProperty("range", (Number)Float.valueOf(this.range));
        MagicUtil.write(json, this.music, "music");
    }

    @Override
    protected void decodeAdditional(PacketBuffer buffer) {
        this.blacklist = MagicUtil.decodeColl(buffer, b -> b.func_192575_l(), new HashSet());
        this.range = buffer.readFloat();
    }

    @Override
    protected void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encodeColl(buffer, this.blacklist, (b, rl) -> b.func_192572_a(rl));
        buffer.writeFloat(this.range);
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    public void magicStart(World world, PlayerEntity player, ItemStack staff) {
        if (!world.field_72995_K) {
            Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new JukeboxMagicMessage(player.func_110124_au(), this.music));
        }
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{new StringTextComponent(String.valueOf(this.range))};
    }

    @Override
    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
        List entities = world.func_175647_a(LivingEntity.class, player.func_174813_aQ().func_186662_g((double)this.range), e -> e != player && !this.blacklist.contains(e.func_200600_R().getRegistryName()));
        for (LivingEntity e2 : entities) {
            if (!world.field_72995_K) {
                if (count % 5 != 0) continue;
                e2.func_195064_c(new EffectInstance(Effects.field_76421_d, 7, 100, false, false, false));
                continue;
            }
            if (e2.field_70173_aa % 5 != 0) continue;
            e2.field_70721_aZ = 1.0f + player.func_70681_au().nextFloat() - 0.5f;
            e2.func_184609_a(Hand.MAIN_HAND);
            e2.func_184609_a(Hand.OFF_HAND);
        }
        if (!world.field_72995_K && !entities.isEmpty()) {
            this.cost(player);
        }
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::swinging;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::swinging;
    }
}

