/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.original;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.Magic.RayMagic;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.particle.MagicDustParticleData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EggMagic
extends RayMagic {
    private Set<ResourceLocation> blacklist;

    public EggMagic(MagicType<? extends EggMagic> type) {
        super((MagicType<? extends RayMagic>)type);
    }

    public EggMagic setAdditionalParams(Set<ResourceLocation> blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.blacklist = MagicUtil.readColl(json, "blacklist", e -> new ResourceLocation(JSONUtils.func_151206_a((JsonElement)e, (String)"entity name")), new HashSet());
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.writeColl(json, "blacklist", this.blacklist, r -> new JsonPrimitive(r.toString()));
    }

    @Override
    public void hitEntity(World world, PlayerEntity player, Entity target) {
        if (this.blacklist.contains(target.func_200600_R().getRegistryName())) {
            target.func_184185_a(ModSounds.POOF, 1.0f, this.soundPitch(player));
            return;
        }
        SpawnEggItem egg = null;
        for (SpawnEggItem e : SpawnEggItem.func_195985_g()) {
            if (e.func_208076_b(null) != target.func_200600_R()) continue;
            egg = e;
            break;
        }
        if (egg != null) {
            target.func_184185_a(ModSounds.PLOP, 1.0f, this.soundPitch(player));
            ItemEntity eggEntity = new ItemEntity(world, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), new ItemStack((IItemProvider)egg));
            world.func_217376_c((Entity)eggEntity);
            target.func_70106_y();
            this.cost(player);
        } else {
            target.func_184185_a(ModSounds.POOF, 1.0f, this.soundPitch(player));
        }
    }

    @Override
    protected IParticleData generateParticle(World world, PlayerEntity player, ItemStack staff, int count) {
        Random rand = player.func_70681_au();
        return new MagicDustParticleData(0.8f + rand.nextFloat() * 0.2f, rand.nextFloat() * 0.2f, 0.8f + rand.nextFloat() * 0.2f, 1.0f);
    }
}

