/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic.netherupdate;

import com.google.gson.JsonObject;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ProjectileMagic
extends Magic {
    private EntityType<?> projectileType;
    private SoundEvent sound;
    private float speed;

    public ProjectileMagic(MagicType<? extends ProjectileMagic> type) {
        super(type);
    }

    public ProjectileMagic setAdditionalParams(EntityType<?> projectileType, SoundEvent sound, float speed) {
        this.projectileType = projectileType;
        this.sound = sound;
        this.speed = speed;
        return this;
    }

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forwardBuildup;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }

    @Override
    protected void readAdditional(JsonObject json) {
        this.projectileType = (EntityType)MagicUtil.read(json, ForgeRegistries.ENTITIES, "projectile");
        this.sound = (SoundEvent)MagicUtil.read(json, ForgeRegistries.SOUND_EVENTS, "sound");
        this.speed = JSONUtils.func_151217_k((JsonObject)json, (String)"speed");
    }

    @Override
    protected void writeAdditional(JsonObject json) {
        MagicUtil.write(json, this.projectileType, "projectile");
        MagicUtil.write(json, this.sound, "sound");
        json.addProperty("speed", (Number)Float.valueOf(this.speed));
    }

    @Override
    public void encodeAdditional(PacketBuffer buffer) {
        MagicUtil.encode(buffer, this.projectileType);
        MagicUtil.encode(buffer, this.sound);
        buffer.writeFloat(this.speed);
    }

    @Override
    public void decodeAdditional(PacketBuffer buffer) {
        this.projectileType = (EntityType)MagicUtil.decode(buffer, ForgeRegistries.ENTITIES);
        this.sound = (SoundEvent)MagicUtil.decode(buffer, ForgeRegistries.SOUND_EVENTS);
        this.speed = buffer.readFloat();
    }

    @Override
    protected Object[] getDescrArgs() {
        return new Object[]{this.projectileType.func_212546_e()};
    }

    @Override
    protected Object[] getNameArgs() {
        return new Object[]{this.projectileType.func_212546_e()};
    }

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        player.func_184185_a(this.sound, 1.0f, this.soundPitch(player));
        if (!world.field_72995_K) {
            Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC());
            Vector3d position = player.func_213303_ch().func_72441_c(direction.func_82615_a() * 1.0, 1.2, direction.func_82616_c() * 1.0);
            this.cost(player);
            Entity entity = this.projectileType.func_200721_a(world);
            entity.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
            if (entity instanceof ProjectileEntity) {
                ProjectileEntity projectile = (ProjectileEntity)entity;
                projectile.func_212361_a((Entity)player);
                projectile.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.speed, 0.0f);
            }
            world.func_217376_c(entity);
        }
        return super.magicFinish(world, player, staff);
    }
}

