/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import mod.vemerion.wizardstaff.Helper.Helper;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModSounds;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class RayMagic
extends Magic {
    public RayMagic(MagicType<? extends RayMagic> type) {
        super(type);
    }

    protected float getRange() {
        return 7.0f;
    }

    @Override
    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
        if (count % 10 == 0) {
            player.func_184185_a(ModSounds.RAY, 0.6f, 0.95f + player.func_70681_au().nextFloat() * 0.05f);
        }
        if (world.field_72995_K) {
            Vector3d direction = Vector3d.func_189984_a((Vector2f)player.func_189653_aC());
            Entity target = Helper.findTargetLine(player.func_213303_ch().func_72441_c(0.0, 1.5, 0.0), direction, this.getRange(), world, (LivingEntity)player);
            if (target != null) {
                Vector3d pos = player.func_213303_ch().func_72441_c(0.0, 1.5, 0.0).func_178787_e(direction);
                for (int i = 0; i < 25; ++i) {
                    world.func_195594_a(this.generateParticle(world, player, staff, count), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.1, 0.1, 0.1);
                    pos = pos.func_178787_e(direction.func_186678_a(0.3));
                    if (target.func_174813_aQ().func_72326_a(new AxisAlignedBB(pos, pos).func_186662_g(0.25))) break;
                }
            }
        }
    }

    protected abstract IParticleData generateParticle(World var1, PlayerEntity var2, ItemStack var3, int var4);

    @Override
    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        Entity target;
        if (!world.field_72995_K && (target = Helper.findTargetLine(player.func_213303_ch().func_72441_c(0.0, 1.5, 0.0), Vector3d.func_189984_a((Vector2f)player.func_189653_aC()), this.getRange(), world, (LivingEntity)player)) != null) {
            this.hitEntity(world, player, target);
        }
        return super.magicFinish(world, player, staff);
    }

    protected abstract void hitEntity(World var1, PlayerEntity var2, Entity var3);

    @Override
    public WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer() {
        return WizardStaffTileEntityRenderer::forward;
    }

    @Override
    public WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer() {
        return WizardStaffLayer::forwardShake;
    }

    @Override
    public UseAction getUseAction(ItemStack stack) {
        return UseAction.BLOCK;
    }
}

