/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import mod.vemerion.wizardstaff.Magic.Magic;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.init.ModMagics;
import mod.vemerion.wizardstaff.network.Network;
import mod.vemerion.wizardstaff.network.UpdateMagicsMessage;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class Magics
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String FOLDER_NAME = "wizard-staff-magics";
    private static Magics clientInstance;
    private static Magics serverInstance;
    private Map<ResourceLocation, Magic> magics = new HashMap<ResourceLocation, Magic>();
    private ImmutableSet<ItemStack> magicItems;
    private Map<Item, ResourceLocation> cache = new HashMap<Item, ResourceLocation>();

    private Magics() {
        super(GSON, FOLDER_NAME);
    }

    public Magic get(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.cache.containsKey(item) && this.magics.get(this.cache.get(item)).isMagicItem(stack)) {
            return this.magics.get(this.cache.get(item));
        }
        for (Map.Entry<ResourceLocation, Magic> entry : this.magics.entrySet()) {
            if (!entry.getValue().isMagicItem(stack)) continue;
            Magic magic = entry.getValue();
            this.cache.put(stack.func_77973_b(), entry.getKey());
            return magic;
        }
        return ModMagics.NO_MAGIC.create();
    }

    public static Magics getInstance(boolean isRemote) {
        return isRemote ? clientInstance : serverInstance;
    }

    public static Magics getInstance(World world) {
        return Magics.getInstance(world.field_72995_K);
    }

    public static void init() {
        clientInstance = new Magics();
        serverInstance = new Magics();
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap<ResourceLocation, Magic> newMagics = new HashMap<ResourceLocation, Magic>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonObject json = JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"top element");
            ResourceLocation magicKey = this.toResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"magic"));
            if (!ModMagics.REGISTRY.containsKey(magicKey)) {
                throw new JsonSyntaxException("The magic " + magicKey + " does not exist");
            }
            MagicType type = (MagicType)ModMagics.REGISTRY.getValue(magicKey);
            if (type == ModMagics.NO_MAGIC) continue;
            Object magic = type.create();
            ((Magic)magic).read(json);
            newMagics.put(key, (Magic)magic);
        }
        this.addMagics(newMagics);
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.sendMagicMessage(newMagics);
        }
    }

    private ResourceLocation toResourceLocation(String string) {
        if (string.contains(":")) {
            return new ResourceLocation(string);
        }
        return new ResourceLocation("wizard-staff", string);
    }

    private void sendMagicMessage(Map<ResourceLocation, Magic> newMagics) {
        Network.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new UpdateMagicsMessage(newMagics));
    }

    public void sendAllMagicMessage(ServerPlayerEntity reciever) {
        Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> reciever), (Object)new UpdateMagicsMessage(this.magics));
    }

    public void addMagics(Map<ResourceLocation, Magic> newMagics) {
        this.cache = new HashMap<Item, ResourceLocation>();
        this.magics.putAll(newMagics);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Magic m : newMagics.values()) {
            for (ItemStack stack : m.getMatchingStacks()) {
                builder.add((Object)stack);
            }
        }
        this.magicItems = builder.build();
    }

    public ImmutableSet<ItemStack> getMagicItems() {
        return this.magicItems;
    }
}

