/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MagicUtil {
    public static <T extends IForgeRegistryEntry<T>> T read(JsonObject json, IForgeRegistry<T> registry, String member) {
        ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)member));
        if (registry.containsKey(key)) {
            return (T)registry.getValue(key);
        }
        throw new JsonParseException("Invalid registry key " + key + " for registry " + registry.getRegistryName().func_110623_a());
    }

    public static <T extends IForgeRegistryEntry<T>> T read(JsonObject json, IForgeRegistry<T> registry, String member, T fallback) {
        return json.has(member) ? MagicUtil.read(json, registry, member) : fallback;
    }

    public static <T extends IForgeRegistryEntry<T>> void write(JsonObject json, T obj, String member) {
        String key = obj.getRegistryName().toString();
        json.addProperty(member, key);
    }

    public static <T extends IForgeRegistryEntry<T>> void encode(PacketBuffer buffer, T obj) {
        String key = obj.getRegistryName().toString();
        buffer.writeInt(key.length());
        buffer.func_180714_a(key);
    }

    public static <T extends IForgeRegistryEntry<T>> T decode(PacketBuffer buffer, IForgeRegistry<T> registry) {
        int keyLen = buffer.readInt();
        return (T)registry.getValue(new ResourceLocation(buffer.func_150789_c(keyLen)));
    }

    public static <T> T read(JsonObject json, Registry<T> registry, String member) {
        ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)member));
        Optional value = registry.func_241873_b(key);
        if (value.isPresent()) {
            return value.get();
        }
        throw new JsonParseException("Invalid registry key " + key + " for registry " + registry.func_243578_f().func_240901_a_().func_110623_a());
    }

    public static <T> T read(JsonObject json, Registry<T> registry, String member, T fallback) {
        return json.has(member) ? MagicUtil.read(json, registry, member) : fallback;
    }

    public static <T> void write(JsonObject json, T obj, Registry<T> registry, String member) {
        json.addProperty(member, registry.func_177774_c(obj).toString());
    }

    public static <T> void encode(PacketBuffer buffer, T obj, Registry<T> registry) {
        String key = registry.func_177774_c(obj).toString();
        buffer.writeInt(key.length());
        buffer.func_180714_a(key);
    }

    public static <T> T decode(PacketBuffer buffer, Registry<T> registry) {
        int keyLen = buffer.readInt();
        return (T)registry.func_82594_a(new ResourceLocation(buffer.func_150789_c(keyLen)));
    }

    public static BlockPos readBlockPos(JsonObject json, String member) {
        Optional pos = BlockPos.field_239578_a_.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get(member)).result();
        if (!pos.isPresent()) {
            throw new JsonParseException("Missing or invalid BlockPos for member " + member);
        }
        return (BlockPos)pos.get();
    }

    public static void writeBlockPos(JsonObject json, String member, BlockPos pos) {
        BlockPos.field_239578_a_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pos).result().ifPresent(elem -> json.add(member, elem));
    }

    public static <T, C extends Collection<T>> C readColl(JsonObject json, String member, Function<JsonElement, T> f, C coll) {
        JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)member);
        array.forEach(e -> coll.add(f.apply((JsonElement)e)));
        return coll;
    }

    public static <T> void writeColl(JsonObject json, String member, Collection<T> coll, Function<T, JsonElement> f) {
        JsonArray array = new JsonArray();
        for (T t : coll) {
            array.add(f.apply(t));
        }
        json.add(member, (JsonElement)array);
    }

    public static <T, C extends Collection<T>> C decodeColl(PacketBuffer buffer, Function<PacketBuffer, T> f, C coll) {
        int count = buffer.readInt();
        for (int i = 0; i < count; ++i) {
            coll.add(f.apply(buffer));
        }
        return coll;
    }

    public static <T> void encodeColl(PacketBuffer buffer, Collection<T> coll, BiConsumer<PacketBuffer, T> f) {
        buffer.writeInt(coll.size());
        for (T t : coll) {
            f.accept(buffer, (PacketBuffer)t);
        }
    }
}

