/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import mod.vemerion.wizardstaff.Magic.MagicType;
import mod.vemerion.wizardstaff.capability.Experience;
import mod.vemerion.wizardstaff.item.MagicArmorItem;
import mod.vemerion.wizardstaff.renderer.WizardStaffLayer;
import mod.vemerion.wizardstaff.renderer.WizardStaffTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class Magic {
    public static final int HOUR = 72000;
    protected float cost;
    protected int duration;
    protected Ingredient ingredient;
    private MagicType<?> type;
    private static final DamageSource MAGIC = new DamageSource("wizard-staff.magic").func_82726_p();

    public Magic(MagicType<?> type) {
        this.type = type;
    }

    public Magic setParams(float cost, int duration, Ingredient ingredient) {
        this.cost = cost;
        this.duration = duration;
        this.ingredient = ingredient;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.type.getRegistryName();
    }

    public void read(JsonObject json) {
        this.cost = JSONUtils.func_151217_k((JsonObject)json, (String)"cost");
        if (this.cost < 0.0f) {
            throw new JsonSyntaxException("The cost of a magic can not be negative");
        }
        this.duration = JSONUtils.func_151203_m((JsonObject)json, (String)"duration");
        if (this.duration < 0) {
            this.duration = 72000;
        }
        this.ingredient = Ingredient.func_199802_a((JsonElement)json.get("ingredient"));
        this.readAdditional(json);
    }

    protected void readAdditional(JsonObject json) {
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        json.addProperty("cost", (Number)Float.valueOf(this.cost));
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("magic", this.getRegistryName().toString());
        json.add("ingredient", this.ingredient.func_200304_c());
        this.writeAdditional(json);
        return json;
    }

    protected void writeAdditional(JsonObject json) {
    }

    public void decode(PacketBuffer buffer) {
        this.cost = buffer.readFloat();
        this.duration = buffer.readInt();
        if (this.duration < 0) {
            this.duration = 72000;
        }
        this.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.decodeAdditional(buffer);
    }

    protected void decodeAdditional(PacketBuffer buffer) {
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeFloat(this.cost);
        buffer.writeInt(this.duration);
        this.ingredient.func_199564_a(buffer);
        this.encodeAdditional(buffer);
    }

    protected void encodeAdditional(PacketBuffer buffer) {
    }

    public final ItemStack[] getMatchingStacks() {
        return this.ingredient.func_193365_a();
    }

    protected float soundPitch(PlayerEntity player) {
        return 0.8f + player.func_70681_au().nextFloat() * 0.4f;
    }

    protected void playSoundServer(World world, PlayerEntity player, SoundEvent sound, float volume, float pitch) {
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    protected final void cost(PlayerEntity player, int multiplier) {
        int whole = Experience.add(player, (double)((float)multiplier * this.cost) * this.discount(player));
        double debt = this.debt(player, whole);
        player.func_195068_e(-whole);
        if (debt > 0.0) {
            player.func_70097_a(DamageSource.field_76376_m, (float)debt);
        }
    }

    protected final void cost(PlayerEntity player) {
        this.cost(player, 1);
    }

    private double discount(PlayerEntity player) {
        return 1.0 - 0.1 * (double)MagicArmorItem.countMagicArmorPieces(player);
    }

    private double debt(PlayerEntity player, double amount) {
        int trueLevel = player.field_71068_ca;
        amount -= (double)(player.field_71106_cc * (float)player.func_71050_bK());
        while (--player.field_71068_ca >= 0 && amount > 0.0) {
            amount -= (double)player.func_71050_bK();
        }
        player.field_71068_ca = trueLevel;
        return amount;
    }

    public final int getUseDuration(ItemStack staff) {
        return this.duration;
    }

    public final boolean isMagicItem(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public abstract WizardStaffTileEntityRenderer.RenderFirstPersonMagic firstPersonRenderer();

    public abstract WizardStaffLayer.RenderThirdPersonMagic thirdPersonRenderer();

    public abstract UseAction getUseAction(ItemStack var1);

    public void magicStart(World world, PlayerEntity player, ItemStack staff) {
    }

    public void magicTick(World world, PlayerEntity player, ItemStack staff, int count) {
    }

    public ItemStack magicFinish(World world, PlayerEntity player, ItemStack staff) {
        return staff;
    }

    public ActionResultType magicInteractBlock(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public void magicCancel(World world, PlayerEntity player, ItemStack staff, int timeLeft) {
    }

    public Description getDescription() {
        return new Description(this.cost, this.duration, this.getRegistryName(), this.getNameArgs(), this.getDescrArgs());
    }

    protected Object[] getDescrArgs() {
        return Description.NO_ARGS;
    }

    protected Object[] getNameArgs() {
        return Description.NO_ARGS;
    }

    public static DamageSource magicDamage() {
        return MAGIC;
    }

    public static DamageSource magicDamage(PlayerEntity player) {
        return new EntityDamageSource("wizard-staff.magicplayer", (Entity)player).func_82726_p();
    }

    public static DamageSource magicDamage(Entity source, PlayerEntity player) {
        return new IndirectEntityDamageSource("wizard-staff.magicindirect", source, (Entity)player).func_82726_p();
    }

    public static class Description {
        private static final Object[] NO_ARGS = new Object[0];
        private float cost;
        private int duration;
        private TranslationTextComponent name;
        private TranslationTextComponent descr;

        private Description(float cost, int duration, ResourceLocation magicName, Object[] nameArgs, Object[] descrArgs) {
            this.cost = cost;
            this.duration = duration;
            this.name = new TranslationTextComponent("gui." + magicName.func_110624_b() + "." + magicName.func_110623_a() + ".name", nameArgs);
            this.descr = new TranslationTextComponent("gui." + magicName.func_110624_b() + "." + magicName.func_110623_a() + ".description", descrArgs);
        }

        public float getCost() {
            return this.cost;
        }

        public int getDuration() {
            return this.duration;
        }

        public TranslationTextComponent getName() {
            return this.name;
        }

        public TranslationTextComponent getDescription() {
            return this.descr;
        }
    }
}

