/*
 * Decompiled with CFR 0.152.
 */
package mod.vemerion.wizardstaff.Magic;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.function.Predicate;
import mod.vemerion.wizardstaff.Magic.MagicUtil;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockMatch
implements Predicate<Block> {
    private Block block;
    private ResourceLocation name;

    public BlockMatch(Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"Block for BlockMatch cannot be null");
        this.block = block;
    }

    public BlockMatch(ResourceLocation tagName) {
        Preconditions.checkNotNull((Object)tagName, (Object)"tagName for BlockMatch cannot be null");
        this.name = tagName;
    }

    public BlockMatch(ITag.INamedTag<Block> tag) {
        Preconditions.checkNotNull(tag, (Object)"tag for BlockMatch cannot be null");
        this.name = tag.func_230234_a_();
    }

    @Override
    public boolean test(Block b) {
        if (this.block != null) {
            return this.block == b;
        }
        return BlockTags.func_199896_a().func_241834_b(this.name).func_230235_a_((Object)b);
    }

    public ITextComponent getName() {
        if (this.block != null) {
            return this.block.func_235333_g_();
        }
        return new StringTextComponent(this.name.func_110623_a());
    }

    public static BlockMatch read(JsonObject json) {
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"block")) {
            return new BlockMatch((Block)MagicUtil.read(json, ForgeRegistries.BLOCKS, "block"));
        }
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"tag")) {
            return new BlockMatch(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag")));
        }
        throw new JsonSyntaxException("BlockMatch must have either block or tag member");
    }

    public JsonObject write() {
        JsonObject json = new JsonObject();
        if (this.block != null) {
            MagicUtil.write(json, this.block, "block");
        } else {
            json.addProperty("tag", this.name.toString());
        }
        return json;
    }

    public static BlockMatch decode(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            return new BlockMatch((Block)MagicUtil.decode(buffer, ForgeRegistries.BLOCKS));
        }
        return new BlockMatch(buffer.func_192575_l());
    }

    public void encode(PacketBuffer buffer) {
        if (this.block != null) {
            buffer.writeBoolean(true);
            MagicUtil.encode(buffer, this.block);
        } else {
            buffer.writeBoolean(false);
            buffer.func_192572_a(this.name);
        }
    }
}

