/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.google.common.cache.LoadingCache;
import com.tom.cpl.util.HTTPMultipart;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;

public class MojangSkinUploadAPI {
    private String auth;
    private UUID uuid;

    public MojangSkinUploadAPI(UUID uuid, String auth) {
        this.uuid = uuid;
        this.auth = auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadSkin(SkinType skinType, Image skin) throws IOException {
        if (skinType == null || skinType == SkinType.UNKNOWN) {
            throw new IOException("Invalid skin type");
        }
        if (this.uuid == null || this.auth == null) {
            throw new IOException("Missing auth info");
        }
        URL url = new URL("https://api.minecraftservices.com/minecraft/profile/skins");
        HTTPMultipart req = new HTTPMultipart();
        req.addString("variant", skinType.getApiName().toLowerCase());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        skin.storeTo(baos);
        req.addBinary("file", "skin.png", "image/png", baos.toByteArray());
        req.encode();
        Log.info("[MojangSkinsAPI.uploadSkin]: Uploading skin");
        InputStream web = null;
        HttpURLConnection httpCon = null;
        try {
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setRequestProperty("Authorization", "Bearer " + this.auth);
            httpCon.setRequestProperty("Content-Type", req.getContentType());
            httpCon.setRequestProperty("Content-Length", Integer.toString(req.getLen()));
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("POST");
            req.writeTo(httpCon.getOutputStream());
            web = httpCon.getInputStream();
            Log.info("[MojangSkinsAPI.uploadSkin]: Response " + httpCon.getResponseCode());
        }
        finally {
            if (httpCon != null) {
                httpCon.disconnect();
            }
            if (web != null) {
                try {
                    web.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkAuth() {
        try {
            if (this.auth == null) {
                throw new NullPointerException("Missing auth info");
            }
            URL url = new URL("https://api.mojang.com/user/security/location");
            Log.info("[MojangSkinsAPI.checkAuth]: Authorizing mojang api");
            InputStream web = null;
            HttpURLConnection httpCon = null;
            try {
                httpCon = (HttpURLConnection)url.openConnection();
                httpCon.setRequestProperty("Authorization", "Bearer " + this.auth);
                web = httpCon.getInputStream();
                Log.info("[MojangSkinsAPI.checkAuth]: Response " + httpCon.getResponseCode());
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                Log.warn("Mojang API error", e);
                return false;
            }
            finally {
                if (httpCon != null) {
                    httpCon.disconnect();
                }
                if (web != null) {
                    try {
                        web.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception e2) {
            Log.warn("[MojangSkinsAPI.checkAuth]: Failed to begin auth", e2);
        }
        return false;
    }

    public static void clearYggdrasilCache(Object yss) {
        try {
            for (Field f : yss.getClass().getDeclaredFields()) {
                if (f.getType() != LoadingCache.class) continue;
                f.setAccessible(true);
                LoadingCache cache = (LoadingCache)f.get(yss);
                cache.invalidateAll();
                return;
            }
            throw new NoSuchFieldError("Couldn't find cache in " + yss);
        }
        catch (Throwable e) {
            Log.warn("Failed to clear skin cache", e);
            return;
        }
    }
}

