/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.skin;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.LegacySkinConverter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class PlayerTextureLoader {
    private Map<TextureType, Texture> textures = new HashMap<TextureType, Texture>();
    private CompletableFuture<Void> loadFuture;

    public CompletableFuture<Void> load() {
        if (this.loadFuture == null) {
            this.loadFuture = this.load0();
            if (MinecraftObjectHolder.DEBUGGING) {
                this.loadFuture.complete(null);
            }
        }
        return this.loadFuture;
    }

    protected abstract CompletableFuture<Void> load0();

    protected void defineTexture(TextureType type, String url) {
        this.textures.computeIfAbsent(type, Texture::new).url = url;
    }

    protected <Ty extends Enum<Ty>> void defineTexture(Ty type, String url) {
        this.defineTexture(TextureType.valueOf(type.name()), url);
    }

    protected <Ty extends Enum<Ty>, Tx> void defineAll(Map<Ty, Tx> map, Function<Tx, String> toURL) {
        for (Map.Entry<Ty, Tx> e : map.entrySet()) {
            this.defineTexture(TextureType.valueOf(((Enum)e.getKey()).name()), toURL.apply(e.getValue()));
        }
    }

    public CompletableFuture<Image> getTexture(TextureType type) {
        return this.textures.computeIfAbsent(type, Texture::new).get();
    }

    private static class Texture {
        private CompletableFuture<Image> skinFuture;
        private String url;
        private UnaryOperator<Image> postProcessor;

        public Texture(TextureType type) {
            this.postProcessor = type == TextureType.SKIN ? LegacySkinConverter::processLegacySkin : UnaryOperator.identity();
        }

        public CompletableFuture<Image> get() {
            if (this.skinFuture != null) {
                return this.skinFuture;
            }
            this.skinFuture = this.get0();
            if (this.skinFuture == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.skinFuture;
        }

        private CompletableFuture<Image> get0() {
            if (MinecraftObjectHolder.DEBUGGING && new File("skin_test.png").exists()) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        return Image.loadFrom(new File("skin_test.png"));
                    }
                    catch (IOException e) {
                        return null;
                    }
                });
            }
            if (this.url == null) {
                return null;
            }
            return ((CompletableFuture)Image.download(this.url).thenApply(this.postProcessor)).exceptionally(e -> null);
        }
    }
}

