/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import java.io.IOException;
import java.util.UUID;

public class ModelPartUUIDLockout
implements IModelPart,
IResolvedModelPart {
    private UUID lockID;

    public ModelPartUUIDLockout(IOHelper in, ModelDefinition def) throws IOException {
        this.lockID = in.readUUID();
    }

    public ModelPartUUIDLockout(UUID uuid) {
        this.lockID = uuid;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeUUID(this.lockID);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.UUID_LOCK;
    }

    @Override
    public void apply(ModelDefinition def) {
        UUID uuid = def.getPlayerObj().getUUID();
        if (!this.lockID.equals(uuid) && !MinecraftClientAccess.get().getClientPlayer().getUUID().equals(uuid)) {
            throw new IllegalStateException("UUID mismatch");
        }
    }
}

