/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartPlayer;
import com.tom.cpm.shared.parts.ModelPartSkin;
import com.tom.cpm.shared.parts.ModelPartTemplate;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ModelPartDefinition
implements IModelPart,
IResolvedModelPart {
    private List<Cube> cubes;
    private List<RenderedCube> rc;
    private List<ModelPartTemplate> templates;
    private List<IModelPart> otherParts;
    private List<IResolvedModelPart> resolvedOtherParts;
    private List<IResolvedModelPart> resolvedTemplates;
    private IModelPart skin;
    private ModelPartPlayer player;
    private IResolvedModelPart skinImage;

    public ModelPartDefinition(IOHelper is, ModelDefinition def) throws IOException {
        int count = is.readVarInt();
        this.cubes = new ArrayList<Cube>();
        for (int i = 0; i < count; ++i) {
            Cube c = Cube.loadDefinitionCube(is);
            c.id = i + 10;
            this.cubes.add(c);
        }
        this.rc = Cube.resolveCubes(this.cubes);
        this.templates = new ArrayList<ModelPartTemplate>();
        this.otherParts = new ArrayList<IModelPart>();
        block8: while (true) {
            IModelPart part;
            if ((part = (IModelPart)is.readObjectBlock(ModelPartType.VALUES, (t, d) -> t.getFactory().create(d, def))) == null) {
                continue;
            }
            if (part instanceof ModelPartEnd) break;
            switch (part.getType()) {
                case TEMPLATE: {
                    this.templates.add((ModelPartTemplate)part);
                    continue block8;
                }
                case SKIN: {
                    if (this.skin != null) {
                        throw new IOException("Multipile skin tags");
                    }
                    this.skin = part;
                    continue block8;
                }
                case DEFINITION: 
                case DEFINITION_LINK: 
                case SKIN_LINK: {
                    throw new IOException("Invalid tag in definition");
                }
                case PLAYER: {
                    if (this.player != null) {
                        throw new IOException("Multipile player tags");
                    }
                    this.player = (ModelPartPlayer)part;
                    continue block8;
                }
                case END: {
                    continue block8;
                }
            }
            this.otherParts.add(part);
        }
    }

    public ModelPartDefinition(ModelPartSkin skin, List<Cube> cubes) {
        this.cubes = cubes;
        this.skin = skin;
        this.otherParts = new ArrayList<IModelPart>();
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        this.resolvedTemplates = new ArrayList<IResolvedModelPart>();
        for (ModelPartTemplate modelPartTemplate : this.templates) {
            IResolvedModelPart part = modelPartTemplate.resolve();
            this.resolvedTemplates.add(part);
            this.rc.addAll(part.getModel());
        }
        if (this.skin != null) {
            this.skinImage = this.skin.resolve();
        }
        this.resolvedOtherParts = new ArrayList<IResolvedModelPart>();
        for (IModelPart iModelPart : this.otherParts) {
            this.resolvedOtherParts.add(iModelPart.resolve());
        }
        return this;
    }

    @Override
    public List<RenderedCube> getModel() {
        return this.rc;
    }

    @Override
    public TextureProvider getSkin() {
        return this.skinImage != null ? this.skinImage.getSkin() : null;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeVarInt(this.cubes.size());
        ArrayList<Cube> lst = new ArrayList<Cube>(this.cubes);
        lst.sort((a, b) -> Integer.compare(a.id, b.id));
        for (Cube cube : lst) {
            Cube.saveDefinitionCube(dout, cube);
        }
        if (this.player != null) {
            dout.writeObjectBlock(this.player);
        }
        if (this.skin != null) {
            dout.writeObjectBlock(this.skin);
        }
        for (IModelPart part : this.otherParts) {
            dout.writeObjectBlock(part);
        }
        dout.writeObjectBlock(ModelPartEnd.END);
    }

    @Override
    public void apply(ModelDefinition def) {
        this.resolvedOtherParts.forEach(p -> p.apply(def));
    }

    @Override
    public void stitch(TextureStitcher stitcher) {
        this.resolvedTemplates.forEach(t -> t.stitch(stitcher));
        this.resolvedOtherParts.forEach(p -> p.stitch(stitcher));
    }

    public void setPlayer(ModelPartPlayer player) {
        this.player = player;
    }

    public void setOtherParts(List<IModelPart> otherParts) {
        this.otherParts = otherParts;
    }

    public ModelPartPlayer getPlayer() {
        return this.player;
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.DEFINITION;
    }

    public String toString() {
        StringBuilder bb = new StringBuilder("PartDefinition\n\tCubes: ");
        bb.append(this.cubes.size());
        bb.append("\n\tSkin:\n\t\t");
        bb.append(String.valueOf(this.skin).replace("\n", "\n\t\t"));
        bb.append("\n\tPlayer:\n\t\t");
        bb.append(String.valueOf(this.player).replace("\n", "\n\t\t"));
        bb.append("\n\tOther:");
        for (IModelPart iModelPart : this.otherParts) {
            bb.append("\n\t\t");
            bb.append(iModelPart.toString().replace("\n", "\n\t\t"));
        }
        return bb.toString();
    }
}

