/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class PerFaceUV {
    public Map<Dir, Face> faces = new HashMap<Dir, Face>();

    public PerFaceUV() {
        for (Dir d : Dir.VALUES) {
            this.faces.put(d, new Face());
        }
    }

    public PerFaceUV(ModelElement el) {
        float w = el.size.x;
        float h = el.size.y;
        float d = el.size.z;
        int ts = Math.abs(el.textureSize);
        int dx = MathHelper.ceil(w * (float)ts);
        int dy = MathHelper.ceil(h * (float)ts);
        int dz = MathHelper.ceil(d * (float)ts);
        int f4 = el.u;
        int f5 = el.u + dz;
        int f6 = el.u + dz + dx;
        int f7 = el.u + dz + dx + dx;
        int f8 = el.u + dz + dx + dz;
        int f9 = el.u + dz + dx + dz + dx;
        int f10 = el.v;
        int f11 = el.v + dz;
        int f12 = el.v + dz + dy;
        this.faces.put(Dir.UP, new Face(f5, f10, f6, f11));
        this.faces.put(Dir.DOWN, new Face(f6, f11, f7, f10));
        this.faces.put(Dir.WEST, new Face(f4, f11, f5, f12));
        this.faces.put(Dir.NORTH, new Face(f5, f11, f6, f12));
        this.faces.put(Dir.EAST, new Face(f6, f11, f8, f12));
        this.faces.put(Dir.SOUTH, new Face(f8, f11, f9, f12));
    }

    public PerFaceUV(PerFaceUV pfUV) {
        pfUV.faces.forEach((d, f) -> this.faces.put((Dir)((Object)d), new Face((Face)f)));
    }

    public PerFaceUV(JsonMap map) {
        for (Dir d : Dir.VALUES) {
            if (!map.containsKey(d.name().toLowerCase())) continue;
            this.faces.put(d, Face.load(map.getMap(d.name().toLowerCase())));
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("PerFaceUV");
        this.faces.forEach((d, f) -> {
            b.append("\n\t");
            b.append(d.name());
            b.append(": ");
            b.append(f);
        });
        return b.toString();
    }

    public void readFaces(IOHelper h) throws IOException {
        int hidden = h.read();
        for (Dir dir : Dir.VALUES) {
            if ((hidden & 1 << dir.ordinal()) == 0) continue;
            Face f = new Face();
            f.sx = h.readVarInt();
            f.sy = h.readVarInt();
            f.ex = h.readVarInt();
            f.ey = h.readVarInt();
            f.rotation = (Rot)h.readEnum(Rot.VALUES);
            this.faces.put(dir, f);
        }
    }

    public void writeFaces(IOHelper h) throws IOException {
        int hidden = 0;
        for (Dir dir : Dir.VALUES) {
            if (this.faces.get((Object)dir) == null) continue;
            hidden |= 1 << dir.ordinal();
        }
        h.write(hidden);
        for (Dir dir : Dir.VALUES) {
            Face face = this.faces.get((Object)dir);
            if (face == null) continue;
            h.writeVarInt(face.sx);
            h.writeVarInt(face.sy);
            h.writeVarInt(face.ex);
            h.writeVarInt(face.ey);
            h.writeEnum(face.rotation);
        }
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        this.faces.forEach((d, f) -> m.put(d.name().toLowerCase(), f.toMap()));
        return m;
    }

    public boolean contains(Dir key) {
        return this.faces.containsKey((Object)key);
    }

    public Face get(Dir key) {
        return this.faces.get((Object)key);
    }

    public Vec4f getVec(Dir key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return new Vec4f(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return f.getVec();
    }

    public Rot getRot(Dir key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return Rot.ROT_0;
        }
        return f.rotation;
    }

    public Boolean isAutoUV(Dir key) {
        Face f = this.faces.get((Object)key);
        if (f == null) {
            return false;
        }
        return f.autoUV;
    }

    public static enum Rot {
        ROT_0,
        ROT_90,
        ROT_180,
        ROT_270;

        public static final Rot[] VALUES;

        static {
            VALUES = Rot.values();
        }
    }

    public static enum Dir {
        UP,
        DOWN,
        NORTH,
        SOUTH,
        EAST,
        WEST;

        public static final Dir[] VALUES;

        static {
            VALUES = Dir.values();
        }
    }

    public static class Face {
        public int sx;
        public int sy;
        public int ex;
        public int ey;
        public Rot rotation = Rot.ROT_0;
        public boolean autoUV;

        public Face() {
        }

        public Face(Face f) {
            this.sx = f.sx;
            this.sy = f.sy;
            this.ex = f.ex;
            this.ey = f.ey;
            this.rotation = f.rotation;
            this.autoUV = f.autoUV;
        }

        private Face(JsonMap m) {
            this.sx = m.getInt("sx");
            this.sy = m.getInt("sy");
            this.ex = m.getInt("ex");
            this.ey = m.getInt("ey");
            String rot = "ROT_" + m.getString("rot");
            for (Rot r : Rot.VALUES) {
                if (!r.name().equals(rot)) continue;
                this.rotation = r;
                break;
            }
            this.autoUV = m.getBoolean("autoUV", false);
        }

        private Face(int sx, int sy, int ex, int ey) {
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
            this.autoUV = true;
        }

        public static Face load(JsonMap m) {
            if (m == null) {
                return null;
            }
            return new Face(m);
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("sx", this.sx);
            m.put("sy", this.sy);
            m.put("ex", this.ex);
            m.put("ey", this.ey);
            m.put("rot", this.rotation.name().toLowerCase().substring(4));
            m.put("autoUV", this.autoUV);
            return m;
        }

        public int getVertexU(int index) {
            int i = this.getVertexRotated(index);
            return i != 0 && i != 1 ? this.ex : this.sx;
        }

        public int getVertexV(int index) {
            int i = this.getVertexRotated(index);
            return i != 0 && i != 3 ? this.ey : this.sy;
        }

        private int getVertexRotated(int index) {
            return (index + this.rotation.ordinal() + 3) % 4;
        }

        public void set(Vec4f v) {
            this.sx = (int)v.x;
            this.sy = (int)v.y;
            this.ex = (int)v.z;
            this.ey = (int)v.w;
        }

        public Vec4f getVec() {
            return new Vec4f(this.sx, this.sy, this.ex, this.ey);
        }
    }
}

