/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.BoundingBox;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.IModelComponent;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.render.ItemRenderer;
import com.tom.cpm.shared.model.render.Mesh;
import com.tom.cpm.shared.model.render.PerFaceUV;
import java.util.ArrayList;
import java.util.List;

public class RenderedCube
implements IModelComponent {
    private Cube cube;
    private RenderedCube parent;
    public List<RenderedCube> children;
    public Vec3f offset;
    public Vec3f rotation;
    public Vec3f pos;
    public Mesh renderObject;
    public boolean display = true;
    public boolean useDynamic = false;
    public int color;
    public boolean glow = false;
    public boolean hidden = false;
    public boolean recolor = false;
    public boolean singleTex = false;
    public PerFaceUV faceUVs;
    public ItemRenderer itemRenderer;

    protected RenderedCube() {
    }

    public RenderedCube(Cube cube) {
        this.cube = cube;
        this.reset();
    }

    @Override
    public void reset() {
        if (this.cube.offset != null) {
            this.offset = new Vec3f(this.cube.offset);
        }
        if (this.cube.rotation != null) {
            this.rotation = new Vec3f(this.cube.rotation);
        }
        if (this.cube.pos != null) {
            this.pos = new Vec3f(this.cube.pos);
        }
        this.color = this.recolor || this.cube.texSize == 0 ? this.cube.rgb : 0xFFFFFF;
        this.display = !this.hidden;
    }

    public void setParent(RenderedCube parent) {
        this.parent = parent;
    }

    public void addChild(RenderedCube cube) {
        if (this.children == null) {
            this.children = new ArrayList<RenderedCube>();
        }
        this.children.add(cube);
    }

    public Cube getCube() {
        return this.cube;
    }

    public boolean doDisplay() {
        return this.display;
    }

    public RenderedCube getParent() {
        return this.parent;
    }

    public ElementSelectMode getSelected() {
        return ElementSelectMode.NULL;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
    }

    public int getId() {
        return this.cube.id;
    }

    @Override
    public void setPosition(boolean add, float x, float y, float z) {
        if (add) {
            this.pos.x += x;
            this.pos.y += y;
            this.pos.z += z;
        } else {
            this.pos.x = x;
            this.pos.y = y;
            this.pos.z = z;
        }
    }

    @Override
    public void setRotation(boolean add, float x, float y, float z) {
        if (add) {
            this.rotation.x += x;
            this.rotation.y += y;
            this.rotation.z += z;
        } else {
            this.rotation.x = x;
            this.rotation.y = y;
            this.rotation.z = z;
        }
    }

    @Override
    public void setVisible(boolean v) {
        this.display = v;
    }

    @Override
    public void setColor(float r, float g, float b) {
        if (this.recolor || this.cube.texSize == 0) {
            this.color = MathHelper.clamp((int)r, 0, 255) << 16 | MathHelper.clamp((int)g, 0, 255) << 8 | MathHelper.clamp((int)b, 0, 255);
        }
    }

    @Override
    public Vec3f getPosition() {
        return this.pos;
    }

    @Override
    public Vec3f getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isVisible() {
        return this.display;
    }

    @Override
    public int getRGB() {
        if (this.cube == null) {
            return -1;
        }
        return this.recolor || this.cube.texSize == 0 ? this.cube.rgb : -1;
    }

    public BoundingBox getBounds() {
        float f = 0.001f;
        float g = f * 2.0f;
        float scale = 0.0625f;
        return BoundingBox.create(this.offset.x * scale - f, this.offset.y * scale - f, this.offset.z * scale - f, this.cube.size.x * scale * this.cube.scale.x + g, this.cube.size.y * scale * this.cube.scale.y + g, this.cube.size.z * scale * this.cube.scale.z + g);
    }

    public static enum ElementSelectMode {
        NULL(false, true),
        SELECTED(true, true),
        SEL_CHILDREN(true, true),
        SEL_ONLY(true, true),
        PAINT_MODE(false, false);

        private boolean renderOutline;
        private boolean applyColor;

        private ElementSelectMode(boolean renderOutline, boolean applyColor) {
            this.renderOutline = renderOutline;
            this.applyColor = applyColor;
        }

        public boolean isRenderOutline() {
            return this.renderOutline;
        }

        public boolean applyColor() {
            return this.applyColor;
        }
    }
}

