/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import java.util.function.Function;

public class RenderManager<G, P, M, D> {
    private Player<P, M> profile;
    private final ModelRenderManager<D, ?, ?, M> renderManager;
    private final ModelDefinitionLoader<G> loader;
    private Function<P, G> getProfile;

    public RenderManager(ModelRenderManager<D, ?, ?, M> renderManager, ModelDefinitionLoader<G> loader, Function<P, G> getProfile) {
        this.renderManager = renderManager;
        this.loader = loader;
        this.getProfile = getProfile;
    }

    public boolean tryBindModel(G gprofile, P player, D buffer, M toBind, String arg, AnimationEngine.AnimationMode mode) {
        ModelDefinition def;
        Player<?, ?> profile;
        if (gprofile == null) {
            gprofile = this.getProfile.apply(player);
        }
        if ((profile = this.loader.loadPlayer(gprofile)) == null) {
            return false;
        }
        if (toBind == null) {
            toBind = profile.getModel();
        }
        if ((def = profile.getModelDefinition()) != null) {
            this.profile = profile;
            if (player != null) {
                profile.updateFromPlayer(player);
            }
            this.renderManager.bindModel(toBind, arg, buffer, def, profile, mode);
            this.renderManager.getAnimationEngine().handleAnimation(profile, mode);
            return true;
        }
        this.renderManager.unbindModel(toBind);
        return false;
    }

    public void tryUnbind() {
        if (this.profile != null) {
            this.renderManager.unbindModel(this.profile.getModel());
            this.profile = null;
        }
    }

    public void tryUnbind(M model) {
        this.renderManager.unbindModel(model);
    }

    public void tryUnbindPlayer(P player) {
        G gprofile = this.getProfile.apply(player);
        Player<?, ?> profile = this.loader.loadPlayer(gprofile);
        if (profile == null) {
            return;
        }
        this.renderManager.unbindModel(profile.getModel());
    }

    public void bindHand(P player, D buffer) {
        this.tryBindModel(null, player, buffer, null, null, AnimationEngine.AnimationMode.HAND);
    }

    public void bindSkull(G profile, D buffer, M model) {
        Player<P, M> prev = this.profile;
        this.tryBindModel(profile, null, buffer, model, null, AnimationEngine.AnimationMode.SKULL);
        this.profile = prev;
    }

    public void bindPlayer(P player, D buffer) {
        this.tryBindModel(null, player, buffer, null, null, AnimationEngine.AnimationMode.PLAYER);
    }

    public void bindElytra(P player, D buffer, M model) {
        this.tryBindModel(null, player, buffer, model, null, AnimationEngine.AnimationMode.PLAYER);
    }

    public void bindArmor(P player, D buffer, M model, int layer) {
        this.tryBindModel(null, player, buffer, model, "armor" + layer, AnimationEngine.AnimationMode.PLAYER);
    }

    public void bindSkin(M model, TextureSheetType tex) {
        this.renderManager.bindSkin(model, null, tex);
    }

    public void bindSkin(TextureSheetType tex) {
        if (this.profile != null) {
            this.bindSkin(this.profile.getModel(), tex);
        }
    }

    public Player<P, M> getBoundPlayer() {
        return this.profile;
    }
}

