/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.gui.panel.SafetyPanel;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.skin.TextureType;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class SocialPlayerPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private ViewportCamera cam;
    private Player<?, ?> player;
    private CompletableFuture<ModelDefinition> def;
    private AnimationHandler animHandler;
    private TextureProvider vanillaSkin;
    private FlowLayout layout;
    private Panel buttonsPanel;

    public SocialPlayerPanel(Frame frm, final Player<?, ?> player, ViewportCamera cam, int w, int h, Runnable reload) {
        super(frm.getGui());
        final Box parentBox = new Box(0, 0, w, h);
        this.setBounds(parentBox);
        this.player = player;
        this.cam = cam;
        this.animHandler = new AnimationHandler(this::getSelectedDefinition);
        String uuid = player.getUUID().toString();
        int s = Math.min(w, h) - 30;
        if (!SocialConfig.isBlocked(uuid) && !this.gui.isShiftDown()) {
            ModelDisplayPanel modelPanel = new ModelDisplayPanel(this.gui, this){

                @Override
                public void draw(MouseEvent event, float partialTicks) {
                    ModelDefinition d;
                    this.gui.drawBox(parentBox.x, parentBox.y, parentBox.w, parentBox.h, this.gui.getColors().popup_background & 0x80FFFFFF);
                    if (SocialPlayerPanel.this.def == null && (d = player.getModelDefinition0()) != null) {
                        switch (d.getResolveState()) {
                            case CLEANED_UP: {
                                break;
                            }
                            case ERRORRED: {
                                this.setLoadingText(this.gui.i18nFormat("label.cpm.errorLoadingModel", d.getError().toString()));
                                break;
                            }
                            case LOADED: {
                                break;
                            }
                            case NEW: 
                            case RESOLVING: {
                                this.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
                                break;
                            }
                            case SAFETY_BLOCKED: {
                                this.setLoadingText(this.gui.i18nFormat("label.cpm.safetyBlocked", new Object[0]));
                                break;
                            }
                        }
                    }
                    super.draw(event, partialTicks);
                }
            };
            modelPanel.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            modelPanel.setBackgroundColor(0);
            modelPanel.setBounds(new Box(w - s - 5, 5, s, s));
            this.addElement(modelPanel);
            ModelDefinition def = player.getModelDefinition0();
            if (def == null) {
                this.def = player.getTextures().load().thenCompose(_v -> player.getTextures().getTexture(TextureType.SKIN).thenApply(i -> {
                    if (i == null) {
                        i = player.getSkinType().getSkinTexture();
                    }
                    this.vanillaSkin = new TextureProvider((Image)i, new Vec2i(64, 64));
                    return ModelDefinition.createVanilla(() -> this.vanillaSkin, player.getSkinType());
                }));
            }
        }
        this.addElement(new Label(this.gui, player.getName()).setBounds(new Box(5, 5, 100, 10)));
        int bpw = w - s - 10;
        this.buttonsPanel = new Panel(this.gui);
        this.buttonsPanel.setBounds(new Box(0, 15, bpw, h));
        this.addElement(this.buttonsPanel);
        this.layout = new FlowLayout(this.buttonsPanel, 5, 1);
        Button friend = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]), null);
        friend.setBounds(new Box(5, 0, bpw - 5, 20));
        friend.setAction(() -> {
            if (SocialConfig.isFriend(uuid)) {
                SocialConfig.removeFriend(uuid);
            } else {
                SocialConfig.addFriend(uuid, player.getName());
            }
            friend.setText(this.gui.i18nFormat(SocialConfig.isFriend(uuid) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]));
            MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(player.getUUID());
            reload.run();
            ModConfig.getCommonConfig().save();
        });
        this.buttonsPanel.addElement(friend);
        Button block = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]), null);
        block.setBounds(new Box(5, 0, bpw - 5, 20));
        block.setAction(() -> {
            if (SocialConfig.isBlocked(uuid)) {
                SocialConfig.removeBlock(uuid);
            } else {
                SocialConfig.blockPlayer(uuid, player.getName());
            }
            block.setText(this.gui.i18nFormat(SocialConfig.isBlocked(uuid) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]));
            MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(player.getUUID());
            reload.run();
            ModConfig.getCommonConfig().save();
        });
        this.buttonsPanel.addElement(block);
        Button playerSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.playerSettings", new Object[0]), () -> frm.openPopup(new SafetyPopup(this, player.getUUID().toString(), player.getName(), reload)));
        playerSettings.setBounds(new Box(5, 0, bpw - 5, 20));
        this.buttonsPanel.addElement(playerSettings);
        this.layout.reflow();
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        ModelDefinition d = this.player.getModelDefinition();
        if (d != null) {
            return d;
        }
        if (this.def != null) {
            return this.def.getNow(null);
        }
        return null;
    }

    @Override
    public ViewportCamera getCamera() {
        return this.cam;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    @Override
    public boolean doRender() {
        return true;
    }

    public void cleanup() {
        if (this.vanillaSkin != null) {
            this.vanillaSkin.free();
        }
    }

    public static class SafetyPopup
    extends PopupPanel {
        private String uuid;
        private String name;

        protected SafetyPopup(Panel parent, String uuid, String name, Runnable reload) {
            super(parent.getGui());
            Box b = parent.getBounds();
            this.setBounds(new Box(0, 0, b.w - 30, b.h - 20));
            this.uuid = uuid;
            this.name = name;
            ConfigEntry.ModConfigFile.ConfigEntryTemp config = ModConfig.getCommonConfig().createTemp();
            ConfigEntry ce = config.getEntry("playerSettings").getEntry(uuid);
            if (ce.keySet().isEmpty()) {
                ce.setString("name", name);
            }
            ScrollPanel scpS = new ScrollPanel(this.gui);
            scpS.setBounds(new Box(5, 5, this.bounds.w - 10, this.bounds.h - 30));
            this.addElement(scpS);
            SafetyPanel sp = new SafetyPanel(this.gui, ce, this.bounds.w - 10, this.getKeyGroup(), uuid, config);
            scpS.setDisplay(sp);
            Button saveBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), () -> {
                config.saveConfig();
                MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(UUID.fromString(uuid));
                reload.run();
                this.close();
            });
            this.addElement(saveBtn);
            saveBtn.setBounds(new Box(5, this.bounds.h - 25, 80, 20));
        }

        public PlayerSpecificConfigKey.KeyGroup getKeyGroup() {
            return SocialConfig.isFriend(this.uuid) ? PlayerSpecificConfigKey.KeyGroup.FRIEND : PlayerSpecificConfigKey.KeyGroup.GLOBAL;
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.sSettingsFor", this.name);
        }
    }
}

