/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.TextureProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ModelsPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private ViewportCamera camera;
    private Frame frm;
    private ScrollPanel list;
    private ModelDisplayPanel display;
    private ModelDefinition selectedDef;
    private String selected;
    private List<ModelPanel> panels;
    private List<Consumer<Vec2i>> sizeSetters;
    private Button set;
    private Button upload;
    private Button simpleSkin;
    private boolean doRender = true;
    private AnimationHandler animHandler;

    public ModelsPanel(Frame frm, ViewportCamera camera) {
        super(frm.getGui());
        Label lbl;
        this.frm = frm;
        this.camera = camera;
        this.sizeSetters = new ArrayList<Consumer<Vec2i>>();
        this.animHandler = new AnimationHandler(this::getSelectedDefinition);
        this.list = new ScrollPanel(this.gui);
        Panel panel = new Panel(this.gui);
        File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
        File[] fs = modelsDir.exists() ? modelsDir.listFiles((f, n) -> n.endsWith(".cpmmodel")) : null;
        String model = ModConfig.getCommonConfig().getString("selectedModel", null);
        Button reset = new Button(this.gui, this.gui.i18nFormat(model == null ? "button.cpm.reset_skin.sel" : "button.cpm.reset_skin", new Object[0]), () -> {
            ModConfig.getCommonConfig().clearValue("selectedModel");
            ModConfig.getCommonConfig().save();
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                MinecraftClientAccess.get().sendSkinUpdate();
            }
        });
        this.sizeSetters.add(s -> reset.setBounds(new Box(0, 0, s.x, 20)));
        panel.addElement(reset);
        this.sizeSetters.add(s -> panel.setBounds(new Box(0, 0, s.x, 40)));
        this.panels = new ArrayList<ModelPanel>();
        if (fs == null || fs.length == 0) {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_skins", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            panel.addElement(lbl);
        } else {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                int y = 20;
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i].getName().equals(".temp.cpmmodel")) continue;
                    try {
                        ModelPanel p = new ModelPanel(this.gui, ModelFile.load(fs[i]), model != null && fs[i].getName().equals(model), y);
                        y += p.getHeight();
                        this.panels.add(p);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int fy = y;
                MinecraftClientAccess.get().executeLater(() -> {
                    this.panels.forEach(panel::addElement);
                    if (panel.getBounds() != null) {
                        int w = panel.getBounds().w;
                        this.panels.forEach(p -> p.setSize(w));
                        panel.setBounds(new Box(0, 0, w, fy));
                    }
                    this.sizeSetters.add(s -> {
                        panel.setBounds(new Box(0, 0, s.x, fy));
                        this.panels.forEach(p -> p.setSize(s.x));
                    });
                    panel.getElements().remove(lbl);
                });
            });
        }
        this.list.setDisplay(panel);
        panel.setBackgroundColor(this.gui.getColors().panel_background & 0xFFFFFF | Integer.MIN_VALUE);
        this.addElement(this.list);
        this.display = new ModelDisplayPanel(this.gui, this);
        this.display.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
        this.addElement(this.display);
        this.set = new Button(this.gui, this.gui.i18nFormat("button.cpm.applySkin", new Object[0]), this::applySelected);
        this.addElement(this.set);
        if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.OFFLINE) {
            this.upload = new Button(this.gui, this.gui.i18nFormat("button.cpm.uploadSkin", new Object[0]), this::uploadSelected);
            this.upload.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.uploadSkin", new Object[0])));
            this.addElement(this.upload);
            this.simpleSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeSkin", new Object[0]), () -> {
                SelectSkinPopup ssp = new SelectSkinPopup(frm, SkinType.DEFAULT, (type, img) -> frm.openPopup(new ConfirmPopup(frm, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> this.upload((SkinType)((Object)((Object)type)), (Image)img), null)));
                ssp.setOnClosed(() -> {
                    this.doRender = true;
                });
                this.doRender = false;
                frm.openPopup(ssp);
            });
            this.simpleSkin.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.changeSkin", new Object[0])));
            this.addElement(this.simpleSkin);
        }
        Player<?, ?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
        player.getDefinitionFuture().thenAccept(d -> {
            if (this.selectedDef == null) {
                this.selectedDef = d;
            }
            this.animHandler.clear();
        });
        if (player.forcedSkin) {
            Label lbl2 = new Label(this.gui, this.gui.i18nFormat("label.cpm.skinForced", new Object[0]));
            lbl2.setColor(-65536);
            lbl2.setBounds(new Box(40, 30, 0, 0));
            this.addElement(lbl2);
        }
    }

    public void setSize(int width, int height) {
        Vec2i s = new Vec2i(width / 2 - 30, height - 50);
        this.list.setBounds(new Box(20, 40, s.x, s.y));
        this.sizeSetters.forEach(c -> c.accept(s));
        int dispSize = Math.min(width / 2 - 40, height - 100);
        if (this.upload != null) {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 102, height / 2 + dispSize / 2 + 10, 100, 20));
            this.upload.setBounds(new Box(width / 2 + dispSize / 2 + 2, height / 2 + dispSize / 2 + 10, 100, 20));
            this.simpleSkin.setBounds(new Box(width / 2 + dispSize / 2 - 50, 5, 100, 20));
        } else {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 50, height / 2 + dispSize / 2 + 10, 100, 20));
        }
        this.display.setBounds(new Box(width / 2 + 10, height / 2 - dispSize / 2, dispSize, dispSize));
        this.setBounds(new Box(0, 0, width, height));
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        if (this.selectedDef != null) {
            if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                this.selectedDef.startResolve();
            } else if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.LOADED) {
                return this.selectedDef;
            }
        }
        return null;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    private void applySelected() {
        ModConfig.getCommonConfig().setString("selectedModel", this.selected);
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess.get().sendSkinUpdate();
        }
    }

    private void uploadSelected() {
        if (this.selected != null) {
            ModelFile file;
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            File modelF = new File(modelsDir, this.selected);
            try {
                file = ModelFile.load(modelF);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (!file.convertable()) {
                this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("label.cpm.modelNotSkinCompatible", new Object[0]))));
                return;
            }
            SelectSkinPopup ssp = new SelectSkinPopup(this.frm, SkinType.DEFAULT, (type, img) -> this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> Exporter.convert(file, img, type, out -> this.upload((SkinType)((Object)type), (Image)out), () -> this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("label.cpm.convertFail", new Object[0]))))), null)));
            ssp.setOnClosed(() -> {
                this.doRender = true;
            });
            this.doRender = false;
            this.frm.openPopup(ssp);
        }
    }

    private void upload(SkinType type, Image img) {
        new SkinUploadPopup(this.frm, type, img).start();
    }

    public void onClosed() {
        this.panels.forEach(rec$ -> ((ModelPanel)rec$).onClosed());
    }

    @Override
    public ViewportCamera getCamera() {
        return this.camera;
    }

    @Override
    public boolean doRender() {
        return this.doRender;
    }

    private class ModelPanel
    extends Panel {
        private TextureProvider icon;
        private Button select;
        private int linesC;
        private int y;

        public ModelPanel(IGui gui, ModelFile file, boolean sel, int y) {
            super(gui);
            Label lbl = new Label(gui, file.getName());
            lbl.setBounds(new Box(68, 5, 100, 10));
            if (sel) {
                lbl.setColor(gui.getColors().button_hover);
            }
            this.addElement(lbl);
            String[] lines = file.getDesc().split("\\\\");
            for (int i = 0; i < lines.length; ++i) {
                this.addElement(new Label(gui, lines[i]).setBounds(new Box(68, 20 + i * 10, 0, 0)));
            }
            this.linesC = lines.length;
            this.y = y;
            this.select = new Button(gui, gui.i18nFormat("button.cpm.select", new Object[0]), () -> {
                ModelsPanel.this.selected = file.getFileName();
                ModelsPanel.this.selectedDef = MinecraftClientAccess.get().getDefinitionLoader().loadModel(file.getDataBlock(), MinecraftClientAccess.get().getClientPlayer());
                file.registerLocalCache(MinecraftClientAccess.get().getDefinitionLoader());
            });
            this.addElement(this.select);
            if (file.getIcon() != null && file.getIcon().getWidth() > 0) {
                MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                    IOHelper.ImageBlock block = file.getIcon();
                    try {
                        block.doReadImage();
                        if (block.getImage() != null) {
                            this.icon = new TextureProvider(block.getImage(), null);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }

        public void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 2, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        public int getHeight() {
            return Math.max(64, this.linesC * 10 + 30);
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 1, this.bounds.y + 1, 64, 64, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }

        private void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }
    }
}

