/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MojangSkinUploadAPI;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class SkinUploadPopup
extends ProcessPopup<Void> {
    private SkinType type;
    private Image img;
    private List<GuiElement> labelsOld;

    public SkinUploadPopup(Frame frm, SkinType type, Image img) {
        super(frm);
        this.type = type;
        this.img = img;
        this.title = this.gui.i18nFormat("label.cpm.uploading", new Object[0]);
        this.finished = v -> {};
        this.error = thr -> {
            Log.error("Unchecked exception while uploading skin", thr);
            frm.openPopup(new MessagePopup(this.frame, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("error.cpm.unknownError", new Object[0]))));
        };
        this.function = this::process;
        this.reSetupLabels("");
    }

    private Void process() {
        this.setupLabelsExec(this.gui.i18nFormat("label.cpm.uploading.connecting", new Object[0]));
        MojangSkinUploadAPI api = MinecraftClientAccess.get().getUploadAPI();
        if (!api.checkAuth()) {
            if (this.cancelled.get()) {
                return null;
            }
            this.gui.executeLater(new ConfirmPopup(this.frame, this.title, this.gui.i18nFormat("label.cpm.uploading.authFail", new Object[0]), this::save, null, this.gui.i18nFormat("button.cpm.saveSkinFile", new Object[0])));
            return null;
        }
        if (this.cancelled.get()) {
            return null;
        }
        this.setupLabelsExec(this.gui.i18nFormat("label.cpm.uploading.skin", new Object[0]));
        try {
            api.uploadSkin(this.type, this.img);
        }
        catch (Exception e) {
            if (this.cancelled.get()) {
                return null;
            }
            Log.warn("Failed to upload skin", e);
            this.gui.executeLater(new ConfirmPopup(this.frame, this.title, this.gui.i18nFormat("label.cpm.skinUpload.fail", e.getMessage()), this::save, null, this.gui.i18nFormat("button.cpm.saveSkinFile", new Object[0])));
            return null;
        }
        this.gui.executeLater(new MessagePopup(this.frame, this.gui.i18nFormat("label.cpm.export_success", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.success", new Object[0])));
        this.gui.executeLater(MinecraftClientAccess.get()::clearSkinCache);
        return null;
    }

    private void setupLabelsExec(String text) {
        this.gui.executeLater(() -> this.reSetupLabels(text));
    }

    private void reSetupLabels(String text) {
        if (this.labelsOld != null) {
            this.labelsOld.forEach(this::remove);
        }
        this.labelsOld = this.setupLabels(text);
    }

    private void save() {
        FileChooserPopup fc = new FileChooserPopup(this.frame);
        fc.setTitle(this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]));
        fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_png", new Object[0]));
        fc.setFilter(new FileChooserPopup.FileFilter("png"));
        fc.setSaveDialog(true);
        fc.setExtAdder(n -> n + ".png");
        fc.setAccept(f -> {
            try {
                this.img.storeTo((File)f);
            }
            catch (IOException e) {
                Log.error("Failed to save image", e);
                this.frame.openPopup(new MessagePopup(this.frame, this.frame.getGui().i18nFormat("label.cpm.error", new Object[0]), this.frame.getGui().i18nFormat("error.cpm.img_save_failed", e.getLocalizedMessage())));
            }
        });
        fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
        this.frame.openPopup(fc);
    }
}

