/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.gui.ModelsGui;
import com.tom.cpm.shared.gui.SocialGui;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;

public class GestureGui
extends Frame {
    private GestureButton hoveredBtn;
    private Panel panel;

    public GestureGui(IGui gui) {
        super(gui);
        gui.setCloseListener(r -> {
            ModConfig.getCommonConfig().save();
            r.run();
        });
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.hoveredBtn != null) {
            ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
            String hoveredID = this.hoveredBtn.pose != null ? "p" + this.hoveredBtn.pose.getName() : "g" + ((GestureButton)this.hoveredBtn).gesture.name;
            String keybindPressed = null;
            ArrayList<String> dup = new ArrayList<String>();
            for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                if (!kb.getName().startsWith("qa")) continue;
                if (kb.isPressed(event)) {
                    keybindPressed = kb.getName();
                    continue;
                }
                String c = ce.getString(kb.getName(), null);
                if (c == null || !c.equals(hoveredID)) continue;
                dup.add(kb.getName());
            }
            if (keybindPressed != null) {
                ce.setString(keybindPressed, hoveredID);
                for (String k : dup) {
                    ce.setString(k, "");
                }
            }
            this.panel.getElements().forEach(e -> ((GestureButton)e).getKb());
        }
        super.keyPressed(event);
    }

    @Override
    public void initFrame(int width, int height) {
        String k;
        String str;
        Label lbl;
        int h;
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition0();
        Log.debug(def);
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE) {
            String str2 = "How did you get here?";
            Label lbl2 = new Label(this.gui, str2);
            lbl2.setBounds(new Box(width / 2 - this.gui.textWidth(str2) / 2, height / 2 - 4, 0, 0));
            this.addElement(lbl2);
            return;
        }
        if (def != null && def.getResolveState() == ModelDefinition.ModelLoadingState.LOADED && status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            int[] id = new int[]{0};
            this.panel = new Panel(this.gui);
            def.getAnimations().getGestures().forEach((nm, g) -> {
                int n = id[0];
                id[0] = n + 1;
                this.panel.addElement(new GestureButton((AnimationRegistry.Gesture)g, n));
            });
            def.getAnimations().getCustomPoses().forEach((nm, g) -> {
                int n = id[0];
                id[0] = n + 1;
                this.panel.addElement(new GestureButton((CustomPose)g, n));
            });
            if (id[0] == 0) {
                String str3 = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
                Label lbl3 = new Label(this.gui, str3);
                lbl3.setBounds(new Box(width / 2 - this.gui.textWidth(str3) / 2, height / 2 - 4, 0, 0));
                this.addElement(lbl3);
                h = 10;
            } else {
                h = (id[0] / 4 + 1) * 40;
                this.panel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2, 360, h));
                this.addElement(this.panel);
            }
        } else if (def != null && (def.getResolveState() == ModelDefinition.ModelLoadingState.ERRORRED || def.getResolveState() == ModelDefinition.ModelLoadingState.SAFETY_BLOCKED)) {
            String txt = "";
            switch (def.getResolveState()) {
                case ERRORRED: {
                    txt = this.gui.i18nFormat("label.cpm.errorLoadingModel", def.getError().toString());
                    break;
                }
                case SAFETY_BLOCKED: {
                    txt = this.gui.i18nFormat("label.cpm.safetyBlocked", new Object[0]);
                    break;
                }
            }
            if (!txt.isEmpty()) {
                lbl = new Label(this.gui, txt);
                lbl.setBounds(new Box(width / 2 - this.gui.textWidth(txt) / 2, height / 2 - 4, 0, 0));
                this.addElement(lbl);
            }
            h = 10;
        } else if (status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            str = this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0]);
            lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            this.addElement(lbl);
            h = 10;
        } else {
            str = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
            lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            this.addElement(lbl);
            h = 10;
        }
        Panel btnPanel = new Panel(this.gui);
        btnPanel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2 - 30, 360, 20));
        this.addElement(btnPanel);
        if (status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            Button btnRstG = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_gesture", new Object[0]), () -> this.setGesture(null));
            btnRstG.setBounds(new Box(0, 0, 100, 20));
            btnPanel.addElement(btnRstG);
            Button btnRstP = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_pose", new Object[0]), () -> this.setPose(null));
            btnRstP.setBounds(new Box(110, 0, 100, 20));
            btnPanel.addElement(btnRstP);
        }
        Checkbox chbxNames = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_name", new Object[0]));
        chbxNames.setBounds(new Box(220, 0, 70, 20));
        chbxNames.setSelected(Player.isEnableNames());
        chbxNames.setAction(() -> {
            boolean v = !chbxNames.isSelected();
            chbxNames.setSelected(v);
            Player.setEnableNames(v);
        });
        btnPanel.addElement(chbxNames);
        Panel btnPanel2 = new Panel(this.gui);
        btnPanel2.setBounds(new Box(width - 162, 0, 160, 0));
        this.addElement(btnPanel2);
        FlowLayout fl = new FlowLayout(btnPanel2, 0, 1);
        Button btnSocial = new Button(this.gui, this.gui.i18nFormat("button.cpm.socialMenu", new Object[0]), () -> MinecraftClientAccess.get().openGui(SocialGui::new));
        btnSocial.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnSocial);
        Button btnCleanCache = new Button(this.gui, this.gui.i18nFormat("button.cpm.reload_models", new Object[0]), MinecraftClientAccess.get().getDefinitionLoader()::clearCache);
        btnCleanCache.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnCleanCache);
        IKeybind rtkb = null;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("renderToggle")) continue;
            rtkb = kb;
        }
        String string = k = rtkb == null ? "?" : rtkb.getBoundKey();
        if (k.isEmpty()) {
            k = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
        }
        Checkbox chbxRender = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_models", k));
        chbxRender.setBounds(new Box(0, 0, 160, 20));
        chbxRender.setSelected(Player.isEnableRendering());
        chbxRender.setAction(() -> {
            boolean v = !chbxRender.isSelected();
            chbxRender.setSelected(v);
            Player.setEnableRendering(v);
        });
        btnPanel2.addElement(chbxRender);
        fl.reflow();
        Box bp2 = btnPanel2.getBounds();
        btnPanel2.setBounds(new Box(bp2.x, height - bp2.h - 2, bp2.w, bp2.h));
        Panel btnPanel3 = new Panel(this.gui);
        btnPanel3.setBounds(new Box(0, height - 20, 160, 50));
        this.addElement(btnPanel3);
        Button btnSkinMenu = new Button(this.gui, this.gui.i18nFormat("button.cpm.models", new Object[0]), () -> MinecraftClientAccess.get().openGui(ModelsGui::new));
        btnSkinMenu.setBounds(new Box(0, 0, 160, 20));
        btnPanel3.addElement(btnSkinMenu);
        if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
            btnSkinMenu.setEnabled(false);
            btnSkinMenu.setTooltip(new Tooltip(this, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks) {
        TextureProvider skin;
        this.hoveredBtn = null;
        super.draw(mouseX, mouseY, partialTicks);
        int i = 0;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("qa")) continue;
            ++i;
            String k = kb.getBoundKey();
            if (k.isEmpty()) {
                k = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            }
            this.gui.drawText(10, i * 10, this.gui.i18nFormat("label.cpm.quick_key_bound", i, k), -1);
        }
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isAltDown() && def != null && (skin = def.getTexture(TextureSheetType.SKIN, true)) != null && skin.texture != null) {
            skin.bind();
            int size = Math.min(this.bounds.w, this.bounds.h);
            this.gui.drawText(514, 2, "Stitched: " + def.isStitchedTexture(), -1);
            this.gui.drawBox(0, 0, size, size, -5592406);
            this.gui.drawTexture(0, 0, size, size, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    private void setGesture(AnimationRegistry.Gesture g) {
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().playGesture(def.getAnimations(), g);
        }
    }

    private void setPose(CustomPose pose) {
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition();
        if (def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setCustomPose(def.getAnimations(), pose);
        }
    }

    private class GestureButton
    extends Button {
        private AnimationRegistry.Gesture gesture;
        private CustomPose pose;
        private String kb;

        public GestureButton(String name, int id) {
            super(GestureGui.this.getGui(), name, null);
            this.setBounds(new Box(id % 4 * 90, id / 4 * 40, 80, 30));
        }

        public GestureButton(AnimationRegistry.Gesture g, int id) {
            this(g.name, id);
            this.setAction(() -> GestureGui.this.setGesture(g));
            this.gesture = g;
            this.getKb();
        }

        public GestureButton(CustomPose pose, int id) {
            this(pose.getName(), id);
            this.setAction(() -> GestureGui.this.setPose(pose));
            this.pose = pose;
            this.getKb();
        }

        public void getKb() {
            ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
            this.kb = null;
            for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                String c;
                if (!kb.getName().startsWith("qa") || (c = ce.getString(kb.getName(), null)) == null) continue;
                if (this.pose != null && c.startsWith("p") && c.substring(1).equals(this.pose.getName())) {
                    this.kb = kb.getName();
                    break;
                }
                if (this.gesture == null || !c.startsWith("g") || !c.substring(1).equals(this.gesture.name)) continue;
                this.kb = kb.getName();
                break;
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            int w = this.gui.textWidth(this.name);
            int bgColor = this.gui.getColors().button_fill;
            int color = this.gui.getColors().button_text_color;
            if (!this.enabled) {
                color = this.gui.getColors().button_text_disabled;
                bgColor = this.gui.getColors().button_disabled;
            } else if (event.isHovered(this.bounds)) {
                color = this.gui.getColors().button_text_hover;
                bgColor = this.gui.getColors().button_hover;
            }
            this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
            this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 8, this.name, color);
            if (this.kb != null) {
                for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                    if (!kb.getName().equals(this.kb)) continue;
                    String k = kb.getBoundKey();
                    if (k.isEmpty()) {
                        k = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
                    }
                    this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 + 4, k, color);
                    break;
                }
            }
            if (event.isHovered(this.bounds)) {
                GestureGui.this.hoveredBtn = this;
            }
        }
    }
}

