/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.tree;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.elements.Tree;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Effect;
import java.util.function.Consumer;

public interface TreeElement {
    public String getName();

    default public int textColor() {
        return 0;
    }

    default public int bgColor() {
        return 0;
    }

    default public void accept(TreeElement elem) {
        throw new UnsupportedOperationException();
    }

    default public boolean canAccept(TreeElement elem) {
        return false;
    }

    default public boolean canMove() {
        return false;
    }

    default public void getTreeElements(Consumer<TreeElement> c) {
    }

    default public void onClick(MouseEvent evt) {
    }

    default public void populatePopup(PopupMenu popup) {
    }

    default public Tooltip getTooltip() {
        return null;
    }

    default public void setVec(Vec3f v, VecType object) {
    }

    default public void setElemName(String name) {
    }

    default public String getElemName() {
        return "";
    }

    default public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
    }

    default public ETextures getTexture() {
        return null;
    }

    default public Box getTextureBox() {
        return null;
    }

    default public void modeSwitch() {
    }

    default public void updateGui() {
    }

    default public void onRefreshTree() {
    }

    default public void addNew() {
    }

    default public void delete() {
    }

    default public void setElemColor(int color) {
    }

    default public void setMCScale(float scale) {
    }

    default public void switchVis() {
    }

    default public void switchEffect(Effect effect) {
    }

    default public float getValue() {
        return 0.0f;
    }

    default public void setValue(float value) {
    }

    default public void render3d(MatrixStack stack, VBuffers buf) {
    }

    public static enum VecType {
        SIZE,
        OFFSET,
        ROTATION,
        POSITION,
        SCALE,
        TEXTURE;

    }

    public static class ModelTree
    extends Tree.TreeModel<TreeElement> {
        private Editor e;
        private TreeElement moveElem;

        public ModelTree(Editor e) {
            this.e = e;
        }

        @Override
        protected int textColor(TreeElement val) {
            return val.textColor();
        }

        @Override
        protected void getElements(TreeElement parent, Consumer<TreeElement> c) {
            if (parent == null) {
                this.e.elements.forEach(c);
                this.e.templates.forEach(c);
                if (this.e.templateSettings != null) {
                    c.accept(this.e.templateSettings);
                }
                if (this.e.scaling != 0.0f) {
                    c.accept(this.e.scalingElem);
                }
                c.accept(this.e.texElem);
            } else {
                parent.getTreeElements(c);
            }
        }

        @Override
        protected int bgColor(TreeElement val) {
            int bg = val.bgColor();
            if (bg != 0) {
                return bg;
            }
            if (this.moveElem != null && this.moveElem == val) {
                return this.e.gui().getColors().move_background;
            }
            if (this.e.selectedElement == val) {
                return this.e.colors().select_background;
            }
            return 0;
        }

        @Override
        protected void treeUpdated() {
            this.e.updateGui();
        }

        @Override
        protected void onClick(MouseEvent evt, TreeElement elem) {
            if (evt.btn == 1 && elem != null) {
                PopupMenu popup = new PopupMenu(this.e.gui(), this.e.frame);
                if (elem.canMove() || this.moveElem != null && elem.canAccept(this.moveElem)) {
                    popup.addButton(this.moveElem != null ? this.e.gui().i18nFormat("button.cpm.tree.put", new Object[0]) : this.e.gui().i18nFormat("button.cpm.tree.move", new Object[0]), () -> {
                        if (this.moveElem != null) {
                            if (this.moveElem != elem) {
                                elem.accept(this.moveElem);
                            }
                            this.moveElem = null;
                        } else {
                            this.moveElem = elem;
                        }
                    });
                }
                elem.populatePopup(popup);
                if (!popup.getElements().isEmpty()) {
                    Vec2i p = evt.getPos();
                    popup.display(p.x, p.y);
                }
            } else {
                if (elem != null) {
                    elem.onClick(evt);
                }
                this.e.selectedElement = elem;
            }
        }

        @Override
        protected String getName(TreeElement elem) {
            return elem.getName();
        }

        @Override
        protected Tooltip getTooltip(TreeElement elem) {
            if (elem != null) {
                return elem.getTooltip();
            }
            return null;
        }

        @Override
        protected void refresh(TreeElement elem) {
            elem.onRefreshTree();
        }
    }
}

