/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.template;

import com.tom.cpl.gui.elements.ChooseElementPopup;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.util.NamedElement;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.template.TemplateArgType;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.template.Template;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TemplateArgHandler
implements TreeElement {
    public String name;
    public String desc;
    public Tooltip tooltip;
    public Editor editor;
    public List<TreeElement> options;
    public List<ModelElement> effectedElems;
    public TemplateArgType type;
    public TemplateArg<?> handler;

    public TemplateArgHandler(Editor e, String name, String descIn, TemplateArgType type) {
        this.editor = e;
        this.name = name;
        this.desc = descIn;
        this.tooltip = this.desc.isEmpty() ? null : new Tooltip(e.frame, this.desc);
        this.type = type;
        this.options = new ArrayList<TreeElement>();
        this.options.add(new TreeElement(){

            @Override
            public String getName() {
                return TemplateArgHandler.this.editor.gui().i18nFormat("label.cpm.desc", new Object[0]);
            }

            @Override
            public void updateGui() {
                TemplateArgHandler.this.editor.updateName.accept(TemplateArgHandler.this.desc);
            }

            @Override
            public String getElemName() {
                return TemplateArgHandler.this.desc;
            }

            @Override
            public void setElemName(String name) {
                TemplateArgHandler.this.desc = name;
            }
        });
        this.handler = type.factory.get();
        if (this.handler.requiresParts()) {
            this.effectedElems = new ArrayList<ModelElement>();
            this.options.add(new TreeElement(){
                private Map<ModelElement, TreeElement> wrappers = new HashMap<ModelElement, TreeElement>();

                @Override
                public String getName() {
                    return TemplateArgHandler.this.editor.gui().i18nFormat("label.cpm.arg_parts", new Object[0]);
                }

                @Override
                public void getTreeElements(Consumer<TreeElement> c) {
                    TemplateArgHandler.this.effectedElems.forEach(e -> c.accept(this.wrappers.computeIfAbsent((ModelElement)e, x$0 -> new ArgElem((ModelElement)x$0))));
                }

                @Override
                public void addNew() {
                    TemplateArgHandler.this.editor.frame.openPopup(new ChooseElementPopup<NamedElement>(TemplateArgHandler.this.editor.frame, TemplateArgHandler.this.editor.gui().i18nFormat("label.cpm.arg_choose_part", new Object[0]), TemplateArgHandler.this.editor.gui().i18nFormat("label.cpm.arg_choose_part.desc", new Object[0]), Util.listFromTree(c -> Editor.walkElements(TemplateArgHandler.this.editor.elements, c)).stream().filter(e -> e.type == ElementType.NORMAL && !e.templateElement).map(t -> new NamedElement<ModelElement>((ModelElement)t, ModelElement::getName)).collect(Collectors.toList()), elem -> {
                        if (elem != null) {
                            TemplateArgHandler.this.editor.action("addToArg").addToList(TemplateArgHandler.this.effectedElems, elem.getElem()).execute();
                            TemplateArgHandler.this.editor.updateGui();
                        }
                    }, null));
                }

                @Override
                public void updateGui() {
                    TemplateArgHandler.this.editor.setAddEn.accept(true);
                }
            });
        }
        this.handler.createTreeElements(this.options, e);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void getTreeElements(Consumer<TreeElement> c) {
        this.options.forEach(c);
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public void delete() {
        this.editor.action("remove", "action.cpm.arg").removeFromList(this.editor.templateSettings.templateArgs, this).execute();
        this.editor.updateGui();
    }

    @Override
    public void updateGui() {
        this.editor.updateName.accept(this.name);
        this.tooltip = this.desc.isEmpty() ? null : new Tooltip(this.editor.frame, this.desc);
    }

    @Override
    public String getElemName() {
        return this.name;
    }

    @Override
    public void setElemName(String name) {
        this.name = name;
    }

    public void applyToModel() {
        if (this.effectedElems != null) {
            this.handler.apply(this.effectedElems);
        }
    }

    public static interface TemplateArg<T extends Template.IArg> {
        default public boolean requiresParts() {
            return true;
        }

        public void saveProject(Map<String, Object> var1);

        public void loadProject(Map<String, Object> var1);

        public void loadTemplate(T var1);

        public T export();

        public void applyArgs(Map<String, Object> var1, List<ModelElement> var2);

        default public void createTreeElements(List<TreeElement> c, Editor editor) {
        }

        default public void apply(List<? extends Cube> parts) {
        }

        default public void applyToArg() {
        }
    }

    public class ArgElem
    implements TreeElement {
        public final ModelElement elem;

        public ArgElem(ModelElement elem) {
            this.elem = elem;
        }

        @Override
        public String getName() {
            return this.elem.getName();
        }

        @Override
        public void delete() {
            TemplateArgHandler.this.editor.action("rmFromArg").removeFromList(TemplateArgHandler.this.effectedElems, this.elem).execute();
            TemplateArgHandler.this.editor.updateGui();
        }

        @Override
        public void updateGui() {
            TemplateArgHandler.this.editor.setDelEn.accept(true);
        }
    }
}

