/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;

public class NewSkinPopup
extends PopupPanel {
    public NewSkinPopup(IGui gui, Editor editor) {
        super(gui);
        Label lblTW = new Label(gui, gui.i18nFormat("label.cpm.width", new Object[0]));
        lblTW.setBounds(new Box(5, 15, 40, 18));
        Label lblTH = new Label(gui, gui.i18nFormat("label.cpm.height", new Object[0]));
        lblTH.setBounds(new Box(75, 15, 40, 18));
        Spinner spinnerW = new Spinner(gui);
        Spinner spinnerH = new Spinner(gui);
        spinnerW.setDp(0);
        spinnerH.setDp(0);
        spinnerW.setBounds(new Box(5, 25, 65, 18));
        spinnerH.setBounds(new Box(75, 25, 65, 18));
        this.addElement(spinnerW);
        this.addElement(spinnerH);
        this.addElement(lblTW);
        this.addElement(lblTH);
        spinnerW.setValue(64.0f);
        spinnerH.setValue(64.0f);
        Label lblT = new Label(gui, gui.i18nFormat("label.cpm.sheetSize", new Object[0]));
        lblT.setBounds(new Box(5, 50, 120, 18));
        lblT.setTooltip(new Tooltip(editor.frame, gui.i18nFormat("tooltip.cpm.texture_sheet", new Object[0])));
        this.addElement(lblT);
        lblTW = new Label(gui, gui.i18nFormat("label.cpm.width", new Object[0]));
        lblTW.setBounds(new Box(5, 60, 40, 18));
        lblTH = new Label(gui, gui.i18nFormat("label.cpm.height", new Object[0]));
        lblTH.setBounds(new Box(75, 60, 40, 18));
        Spinner spinnerTW = new Spinner(gui);
        Spinner spinnerTH = new Spinner(gui);
        spinnerTW.setDp(0);
        spinnerTH.setDp(0);
        spinnerTW.setBounds(new Box(5, 70, 65, 18));
        spinnerTH.setBounds(new Box(75, 70, 65, 18));
        this.addElement(spinnerTW);
        this.addElement(spinnerTH);
        this.addElement(lblTW);
        this.addElement(lblTH);
        spinnerTW.setValue(64.0f);
        spinnerTH.setValue(64.0f);
        Checkbox keepOld = new Checkbox(gui, gui.i18nFormat("label.cpm.keepOldSkin", new Object[0]));
        keepOld.setBounds(new Box(5, 100, 100, 18));
        keepOld.setAction(() -> keepOld.setSelected(!keepOld.isSelected()));
        this.addElement(keepOld);
        Button ok = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> {
            this.close();
            ETextures tex = editor.getTextureProvider();
            if (tex != null) {
                Image oldImg = tex.getImage();
                Image newImage = new Image((int)spinnerW.getValue(), (int)spinnerH.getValue());
                if (keepOld.isSelected()) {
                    newImage.draw(oldImg);
                }
                Vec2i size = new Vec2i((int)spinnerTW.getValue(), (int)spinnerTH.getValue());
                if (size.x == 0) {
                    size.x = (int)spinnerW.getValue();
                }
                if (size.y == 0) {
                    size.y = (int)spinnerH.getValue();
                }
                editor.action("newTexture").updateValueOp(tex, tex.file, null, (a, b) -> {
                    a.file = b;
                }).updateValueOp(tex, tex.isEdited(), true, ETextures::setEdited).updateValueOp(tex, tex.provider.size, size, (a, b) -> {
                    a.provider.size = b;
                }).updateValueOp(tex, oldImg, newImage, ETextures::setImage).onAction(tex::restitchTexture).execute();
                editor.updateGui();
                if (editor.hasVanillaParts() && (size.x != 64 || size.y != 64)) {
                    editor.frame.openPopup(new MessagePopup(editor.frame, gui.i18nFormat("label.cpm.warning", new Object[0]), gui.i18nFormat("label.cpm.skin_has_vanilla_parts", new Object[0])));
                }
            }
        });
        ok.setBounds(new Box(5, 125, 80, 20));
        this.addElement(ok);
        this.setBounds(new Box(0, 0, 150, 150));
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.newSkin", new Object[0]);
    }
}

