/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.CreateGistPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportStringResultPopup;
import com.tom.cpm.shared.editor.gui.popup.ScreenshotPopup;
import com.tom.cpm.shared.editor.util.ModelDescription;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class ExportSkinPopup
extends PopupPanel {
    protected final EditorGui editorGui;
    protected Button ok;
    protected Button modeBtn;

    protected ExportSkinPopup(EditorGui e, int width, int height, ExportMode mode) {
        super(e.getGui());
        this.editorGui = e;
        this.modeBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.as_" + mode.name().toLowerCase(), new Object[0]), () -> {
            this.close();
            for (int i = mode.ordinal() + 1; i < ExportMode.VALUES.length * 2; ++i) {
                ExportMode em = ExportMode.VALUES[i % ExportMode.VALUES.length];
                if (!em.canDisplay.test(e.getEditor())) continue;
                e.openPopup((PopupPanel)em.factory.apply(e));
                return;
            }
        });
        this.modeBtn.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export.as_" + mode.name().toLowerCase(), new Object[0])));
        this.modeBtn.setBounds(new Box(5, 5, 150, 20));
        this.addElement(this.modeBtn);
        this.ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.file.export", new Object[0]), this::export);
        this.ok.setBounds(new Box(5, height - 25, 80, 20));
        this.addElement(this.ok);
        this.setBounds(new Box(0, 0, width, height));
    }

    protected void export() {
        if (Exporter.check(this.editorGui.getEditor(), this.editorGui, this::export)) {
            this.export0();
            this.close();
        }
    }

    protected abstract void export0();

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]);
    }

    public static boolean isTemplate(Editor e) {
        return e.templateSettings != null;
    }

    private static void openScreenshot(EditorGui e, EditorTexture icon, ExportSkinPopup popup) {
        popup.close();
        e.openPopup(new ScreenshotPopup(e, icon::setImage, () -> e.openPopup(popup)));
    }

    public static PopupPanel createPopup(EditorGui e) {
        for (ExportMode m : ExportMode.VALUES) {
            if (!m.canDisplay.test(e.getEditor())) continue;
            return (PopupPanel)m.factory.apply(e);
        }
        IGui gui = e.getGui();
        Log.error("Project can't be exported in any format");
        return new MessagePopup(e, gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.unknownError", new Object[0]));
    }

    private static class Model
    extends ExportSkinPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;
        private Checkbox skinCompat;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Button okDef;
        private boolean gist;

        protected Model(EditorGui e) {
            super(e, 320, 260, ExportMode.MODEL);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 35, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 45, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 70, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 80, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), () -> ExportSkinPopup.openScreenshot(e, this.icon, (ExportSkinPopup)this));
            setIcon.setBounds(new Box(5, 105, 100, 20));
            this.addElement(setIcon);
            this.skinCompat = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.export.skinCompat", new Object[0]));
            this.skinCompat.setBounds(new Box(5, 130, 100, 20));
            this.skinCompat.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skinCompat", new Object[0])));
            this.addElement(this.skinCompat);
            this.skinCompat.setAction(() -> this.skinCompat.setSelected(!this.skinCompat.isSelected()));
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 155, 60, 20));
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.addElement(this.chbxClone);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 180, 60, 20));
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.addElement(this.chbxUUIDLock);
            Button changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), n -> {
                if (editor.description == null) {
                    editor.description = new ModelDescription();
                }
                try {
                    editor.description.uuid = Util.uuidFromString(n);
                    this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
                }
                catch (IllegalArgumentException ex) {
                    e.openPopup(new MessagePopup(e, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
                }
            }, null));
            changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            changeUUID.setBounds(new Box(90, 180, 80, 20));
            this.addElement(changeUUID);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            this.chbxClone.setAction(() -> {
                if (!this.chbxClone.isSelected()) {
                    this.chbxUUIDLock.setSelected(false);
                    this.chbxClone.setSelected(true);
                    changeUUID.setEnabled(false);
                } else {
                    this.chbxClone.setSelected(false);
                }
            });
            this.chbxUUIDLock.setAction(() -> {
                changeUUID.setEnabled(!this.chbxUUIDLock.isSelected());
                if (!this.chbxUUIDLock.isSelected()) {
                    this.chbxUUIDLock.setSelected(true);
                    this.chbxClone.setSelected(false);
                } else {
                    this.chbxUUIDLock.setSelected(false);
                }
            });
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), () -> {
                if (this.defLink != null) {
                    this.gist = true;
                    this.close();
                    this.export();
                }
            });
            this.okDef.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export_def", new Object[0])));
            this.okDef.setBounds(new Box(90, 235, 80, 20));
            this.addElement(this.okDef);
            this.updateHasGist();
        }

        @Override
        protected void export0() {
            ModelDescription.CopyProtection cp;
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            boolean descChanged = false;
            if (editor.description == null) {
                editor.description = new ModelDescription();
                descChanged = true;
            }
            if (!descChanged && !editor.description.name.equals(this.nameField.getText())) {
                descChanged = true;
            }
            if (!descChanged && !editor.description.desc.equals(this.descField.getText())) {
                descChanged = true;
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
            if (editor.description.copyProtection != cp) {
                editor.description.copyProtection = cp;
                descChanged = true;
            }
            if (descChanged) {
                editor.markDirty();
            }
            if (this.gist) {
                Exporter.exportGistUpdate(editor, this.editorGui, gist -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, this.gui, "skin_update", (String)gist)));
            } else {
                File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
                modelsDir.mkdirs();
                String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
                File selFile = new File(modelsDir, fileName);
                if (selFile.exists()) {
                    this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), this.gui.i18nFormat("label.cpm.overwrite", new Object[0]), () -> Exporter.exportModel(editor, this.editorGui, selFile, editor.description, this.skinCompat.isSelected()), null));
                } else {
                    Exporter.exportModel(editor, this.editorGui, selFile, editor.description, this.skinCompat.isSelected());
                }
            }
        }

        private void updateHasGist() {
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            modelsDir.mkdirs();
            String fileName = this.nameField.getText().replaceAll("[^a-zA-Z0-9\\.\\-]", "") + ".cpmmodel";
            File selFile = new File(modelsDir, fileName);
            this.defLink = null;
            if (selFile.exists()) {
                try {
                    ModelFile mf = ModelFile.load(selFile);
                    ModelDefinition def = MinecraftClientAccess.get().getDefinitionLoader().loadModel(mf.getDataBlock(), MinecraftClientAccess.get().getClientPlayer());
                    if (def != null) {
                        this.defLink = def.findDefLink();
                    }
                }
                catch (IOException e) {
                    Log.error("Failed to load file", e);
                }
            }
            this.okDef.setEnabled(this.defLink != null);
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class B64
    extends ExportSkinPopup {
        private Checkbox forceLinkFile;

        protected B64(EditorGui e) {
            super(e, 160, 150, ExportMode.B64);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setAction(() -> this.forceLinkFile.setSelected(!this.forceLinkFile.isSelected()));
            this.forceLinkFile.setBounds(new Box(5, 55, 135, 20));
        }

        @Override
        protected void export0() {
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            Exporter.exportB64(this.editorGui.getEditor(), this.editorGui, b64 -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, this.gui, "base64_model", (String)b64)), this.forceLinkFile.isSelected());
        }
    }

    private static class Template
    extends ExportSkinPopup {
        private TextField nameField;
        private TextField descField;
        private EditorTexture icon;

        protected Template(EditorGui e) {
            super(e, 320, 190, ExportMode.TEMPLATE);
            Editor editor = e.getEditor();
            Label nameLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0]));
            nameLbl.setBounds(new Box(5, 55, 150, 10));
            this.addElement(nameLbl);
            this.nameField = new TextField(this.gui);
            this.nameField.setBounds(new Box(5, 65, 150, 20));
            this.addElement(this.nameField);
            Label descLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.desc", new Object[0]));
            descLbl.setBounds(new Box(5, 90, 150, 10));
            this.addElement(descLbl);
            this.descField = new TextField(this.gui);
            this.descField.setBounds(new Box(5, 100, 150, 20));
            this.addElement(this.descField);
            this.icon = new EditorTexture();
            if (editor.description != null) {
                this.nameField.setText(editor.description.name);
                this.descField.setText(editor.description.desc);
                if (editor.description.icon != null) {
                    this.icon.setImage(editor.description.icon);
                }
            }
            Button setIcon = new Button(this.gui, this.gui.i18nFormat("button.cpm.setIcon", new Object[0]), () -> ExportSkinPopup.openScreenshot(e, this.icon, (ExportSkinPopup)this));
            setIcon.setBounds(new Box(5, 125, 100, 20));
            this.addElement(setIcon);
        }

        @Override
        protected void export0() {
            Editor editor = this.editorGui.getEditor();
            if (editor.templateSettings == null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.projectNotTemplate", new Object[0])));
                return;
            }
            if (editor.description == null) {
                editor.description = new ModelDescription();
            }
            editor.description.name = this.nameField.getText();
            editor.description.desc = this.descField.getText();
            editor.markDirty();
            Exporter.exportTemplate(editor, this.editorGui, editor.description, t -> this.editorGui.openPopup(new CreateGistPopup(this.editorGui, this.gui, "template_export", (String)t, l -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, this.gui, "template", l.toString())))));
        }

        @Override
        public void onClosed() {
            this.icon.free();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon.getImage() != null) {
                this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
                this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static class Skin
    extends ExportSkinPopup {
        private EditorTexture vanillaSkin;
        private Button okDef;
        private Button okUpload;
        private File selFile;
        private Checkbox forceLinkFile;
        private Checkbox chbxClone;
        private Checkbox chbxUUIDLock;
        private Link defLink;
        private Tooltip vanillaSkinTooltip;
        private boolean gist;
        private boolean upload;

        protected Skin(EditorGui e) {
            super(e, 320, 235, ExportMode.SKIN);
            Editor editor = e.getEditor();
            this.vanillaSkin = new EditorTexture();
            this.vanillaSkin.setImage(editor.vanillaSkin);
            Button encSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), () -> e.openPopup(new AnimEncConfigPopup(this.gui, editor, this.vanillaSkin::markDirty)));
            encSettings.setBounds(new Box(5, 30, 150, 20));
            this.addElement(encSettings);
            Button changeVanillaSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.change_vanilla_skin", new Object[0]), () -> {
                SelectSkinPopup ssp = new SelectSkinPopup(editor.frame, editor.skinType, (type, img) -> {
                    editor.vanillaSkin = img;
                    this.vanillaSkin.setImage((Image)img);
                    this.detectDef();
                });
                ssp.setOnClosed(() -> editor.displayViewport.accept(true));
                editor.frame.openPopup(ssp);
                editor.displayViewport.accept(false);
            });
            changeVanillaSkin.setBounds(new Box(5, 55, 150, 20));
            this.addElement(changeVanillaSkin);
            Label vanillaSkinLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.vanilla_skin", new Object[0]));
            vanillaSkinLbl.setBounds(new Box(185, 5, 0, 0));
            this.addElement(vanillaSkinLbl);
            this.forceLinkFile = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.force_link_file", new Object[0]));
            this.addElement(this.forceLinkFile);
            this.forceLinkFile.setBounds(new Box(5, 80, 135, 20));
            this.forceLinkFile.setAction(() -> this.forceLinkFile.setSelected(!this.forceLinkFile.isSelected()));
            this.forceLinkFile.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.force_link_file", new Object[0])));
            Label expOutLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.export_output", new Object[0]));
            expOutLbl.setBounds(new Box(5, 160, 0, 0));
            this.addElement(expOutLbl);
            Label exportName = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_file", new Object[0]));
            exportName.setBounds(new Box(5, 175, 0, 0));
            this.addElement(exportName);
            Button setOut = new Button(this.gui, "...", () -> {
                FileChooserPopup fc = new FileChooserPopup(e);
                fc.setTitle(this.gui.i18nFormat("label.cpm.exportSkin", new Object[0]));
                fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_png", new Object[0]));
                fc.setFilter(new FileChooserPopup.FileFilter("png"));
                fc.setSaveDialog(true);
                fc.setExtAdder(n -> n + ".png");
                fc.setAccept(f -> {
                    this.selFile = f;
                    this.ok.setEnabled(true);
                    this.ok.setTooltip(null);
                    exportName.setText(f.getName());
                });
                fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
                e.openPopup(fc);
            });
            setOut.setBounds(new Box(150, 170, 30, 20));
            this.addElement(setOut);
            this.chbxClone = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.cloneable", new Object[0]));
            this.chbxClone.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.cloneable", new Object[0])));
            this.chbxClone.setBounds(new Box(5, 105, 60, 20));
            this.chbxClone.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.CLONEABLE);
            this.addElement(this.chbxClone);
            this.chbxUUIDLock = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.uuidlock", new Object[0]));
            this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlock", MinecraftClientAccess.get().getClientPlayer().getUUID().toString())));
            this.chbxUUIDLock.setBounds(new Box(5, 130, 60, 20));
            this.chbxUUIDLock.setSelected(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.addElement(this.chbxUUIDLock);
            Button changeUUID = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), new InputPopup(e, this.gui.i18nFormat("button.cpm.changeUUID", new Object[0]), this.gui.i18nFormat("label.cpm.enterNewUUID", new Object[0]), n -> {
                if (editor.description == null) {
                    editor.description = new ModelDescription();
                }
                try {
                    editor.description.uuid = Util.uuidFromString(n);
                    this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
                }
                catch (IllegalArgumentException ex) {
                    e.openPopup(new MessagePopup(e, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.invalidUUID", new Object[0])));
                }
            }, null));
            changeUUID.setBounds(new Box(90, 130, 80, 20));
            changeUUID.setEnabled(editor.description != null && editor.description.copyProtection == ModelDescription.CopyProtection.UUID_LOCK);
            this.addElement(changeUUID);
            if (editor.description != null && editor.description.uuid != null) {
                this.chbxUUIDLock.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.uuidlockOw", editor.description.uuid.toString())));
            }
            this.chbxClone.setAction(() -> {
                if (!this.chbxClone.isSelected()) {
                    this.chbxUUIDLock.setSelected(false);
                    this.chbxClone.setSelected(true);
                    changeUUID.setEnabled(false);
                } else {
                    this.chbxClone.setSelected(false);
                }
            });
            this.chbxUUIDLock.setAction(() -> {
                changeUUID.setEnabled(!this.chbxUUIDLock.isSelected());
                if (!this.chbxUUIDLock.isSelected()) {
                    this.chbxUUIDLock.setSelected(true);
                    this.chbxClone.setSelected(false);
                } else {
                    this.chbxUUIDLock.setSelected(false);
                }
            });
            this.okDef = new Button(this.gui, this.gui.i18nFormat("button.cpm.export_def", new Object[0]), () -> {
                if (this.defLink != null) {
                    this.gist = true;
                    this.close();
                    this.export();
                }
            });
            this.okDef.setBounds(new Box(90, 210, 80, 20));
            this.addElement(this.okDef);
            this.okUpload = new Button(this.gui, this.gui.i18nFormat("button.cpm.export.skin.exportApply", new Object[0]), () -> {
                this.upload = true;
                this.close();
                this.export();
            });
            this.okUpload.setBounds(new Box(175, 210, 100, 20));
            if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.OFFLINE) {
                this.okUpload.setEnabled(false);
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.cantUploadIngame", new Object[0])));
            } else {
                this.okUpload.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.exportApply", new Object[0])));
            }
            this.addElement(this.okUpload);
            this.ok.setEnabled(false);
            this.ok.setTooltip(new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.noFile", new Object[0])));
            this.detectDef();
            this.vanillaSkinTooltip = new Tooltip(e, this.gui.i18nFormat("tooltip.cpm.export.skin.vanillaSkinInfo", new Object[0]));
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 136, this.bounds.y + 14, 130, 130, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, -1);
            this.vanillaSkin.bind();
            this.gui.drawTexture(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128, 0.0f, 0.0f, 1.0f, 1.0f);
            if (event.isHovered(new Box(this.bounds.x + this.bounds.w - 135, this.bounds.y + 15, 128, 128))) {
                this.vanillaSkinTooltip.set();
            }
        }

        @Override
        public void onClosed() {
            this.vanillaSkin.free();
        }

        private void detectDef() {
            ModelDefinition def = MinecraftClientAccess.get().getDefinitionLoader().loadModel(this.editorGui.getEditor().vanillaSkin, MinecraftClientAccess.get().getClientPlayer());
            if (def != null) {
                this.defLink = def.findDefLink();
            }
            this.okDef.setEnabled(this.defLink != null);
            if (this.defLink != null) {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def", new Object[0])));
            } else {
                this.okDef.setTooltip(new Tooltip(this.editorGui, this.gui.i18nFormat("tooltip.cpm.export_def.noLink", new Object[0])));
            }
        }

        @Override
        protected void export0() {
            Editor e = this.editorGui.getEditor();
            if (this.editorGui.getEditor().templateSettings != null) {
                this.editorGui.openPopup(new MessagePopup(this.editorGui, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("error.cpm.templateExportAsSkin", new Object[0])));
                return;
            }
            if (e.description == null && (this.chbxClone.isSelected() || this.chbxUUIDLock.isSelected())) {
                e.description = new ModelDescription();
                e.markDirty();
            }
            if (e.description != null) {
                ModelDescription.CopyProtection cp;
                ModelDescription.CopyProtection copyProtection = this.chbxUUIDLock.isSelected() ? ModelDescription.CopyProtection.UUID_LOCK : (cp = this.chbxClone.isSelected() ? ModelDescription.CopyProtection.CLONEABLE : ModelDescription.CopyProtection.NORMAL);
                if (e.description.copyProtection != cp) {
                    e.description.copyProtection = cp;
                    e.markDirty();
                }
            }
            if (this.gist) {
                Exporter.exportGistUpdate(e, this.editorGui, gist -> this.editorGui.openPopup(new ExportStringResultPopup(this.editorGui, this.gui, "skin_update", (String)gist)));
            } else if (this.upload) {
                this.editorGui.openPopup(new ConfirmPopup(this.editorGui, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> Exporter.exportSkin(e, this.editorGui, img -> new SkinUploadPopup(this.editorGui, e.skinType, (Image)img).start(), this.forceLinkFile.isSelected()), null));
            } else {
                Exporter.exportSkin(e, this.editorGui, this.selFile, this.forceLinkFile.isSelected());
            }
        }
    }

    private static enum ExportMode {
        SKIN(Skin::new, ((Predicate<Editor>)ExportSkinPopup::isTemplate).negate()),
        B64(B64::new, ((Predicate<Editor>)ExportSkinPopup::isTemplate).negate()),
        TEMPLATE(Template::new, ExportSkinPopup::isTemplate),
        MODEL(Model::new, ((Predicate<Editor>)ExportSkinPopup::isTemplate).negate());

        public static final ExportMode[] VALUES;
        private Function<EditorGui, ExportSkinPopup> factory;
        private Predicate<Editor> canDisplay;

        private ExportMode(Function<EditorGui, ExportSkinPopup> factory, Predicate<Editor> canDisplay) {
            this.factory = factory;
            this.canDisplay = canDisplay;
        }

        static {
            VALUES = ExportMode.values();
        }
    }
}

