/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;

public class ColorButton
extends Button {
    private static List<Integer> colorCache = new ArrayList<Integer>();
    private IntConsumer actionColor;
    private int color;

    public ColorButton(IGui gui, Frame frame, IntConsumer action) {
        super(gui, "", null);
        this.action = () -> frame.openPopup(new ColorPopup(gui));
        this.actionColor = action;
    }

    private ColorButton(IGui gui, Runnable action) {
        super(gui, "", null);
        this.action = action;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int bgColor = this.gui.getColors().button_fill;
        if (!this.enabled) {
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        this.gui.drawBox(this.bounds.x + 3, this.bounds.y + 3, this.bounds.w - 6, this.bounds.h - 6, 0xFF000000 | this.color);
    }

    public void setColor(int color) {
        this.color = color;
    }

    private static int rgb2hsv(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        return ((int)(hsv[0] * 255.0f) & 0xFF) << 16 | ((int)(hsv[1] * 255.0f) & 0xFF) << 8 | (int)(hsv[2] * 255.0f) & 0xFF;
    }

    private static int hsv2rgb(int hsv) {
        int h = (hsv & 0xFF0000) >> 16;
        int s = (hsv & 0xFF00) >> 8;
        int v = hsv & 0xFF;
        return Color.HSBtoRGB((float)h / 255.0f, (float)s / 255.0f, (float)v / 255.0f);
    }

    private static class SliderGradient
    extends Slider {
        private int left;
        private int right;

        public SliderGradient(IGui gui) {
            super(gui, "");
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            int textw = this.gui.textWidth(this.name);
            int color = this.gui.getColors().button_text_color;
            if (!this.enabled) {
                color = this.gui.getColors().button_text_disabled;
            } else if (event.isHovered(this.bounds)) {
                color = this.gui.getColors().button_text_hover;
            }
            this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
            if (this.left == 0) {
                float w = (float)(this.bounds.w - 2) / 6.0f;
                int x = this.bounds.x + 1;
                int y = this.bounds.y + 1;
                int h = this.bounds.h - 2;
                int sv = this.right & 0xFFFF;
                for (int i = 0; i < 6; ++i) {
                    int left = 0xFF000000 | ColorButton.hsv2rgb(sv | 42 * i << 16);
                    int right = 0xFF000000 | ColorButton.hsv2rgb(sv | 42 * (i + 1) << 16);
                    this.gui.drawGradientBox((int)((float)x + (float)i * w), y, (int)Math.ceil(w), h, left, right, left, right);
                }
            } else {
                this.gui.drawGradientBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, this.left, this.right, this.left, this.right);
            }
            this.gui.drawBox((int)((float)(this.bounds.x + 1) + this.v * (float)(this.bounds.w - 5)), this.bounds.y + 1, 3, this.bounds.h - 2, this.gui.getColors().slider_bar);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - textw / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
        }

        private void setColor(int left, int right) {
            this.left = left;
            this.right = right | 0xFF000000;
        }
    }

    public class ColorPopup
    extends PopupPanel {
        private SliderGradient sliderR;
        private SliderGradient sliderG;
        private SliderGradient sliderB;
        private SliderGradient sliderH;
        private SliderGradient sliderS;
        private SliderGradient sliderV;
        private Spinner spinnerR;
        private Spinner spinnerG;
        private Spinner spinnerB;
        private Spinner spinnerH;
        private Spinner spinnerS;
        private Spinner spinnerV;
        private TextField hexField;

        public ColorPopup(IGui gui) {
            super(gui);
            this.sliderR = new SliderGradient(gui);
            this.sliderG = new SliderGradient(gui);
            this.sliderB = new SliderGradient(gui);
            this.sliderH = new SliderGradient(gui);
            this.sliderS = new SliderGradient(gui);
            this.sliderV = new SliderGradient(gui);
            this.spinnerR = new Spinner(gui);
            this.spinnerG = new Spinner(gui);
            this.spinnerB = new Spinner(gui);
            this.spinnerH = new Spinner(gui);
            this.spinnerS = new Spinner(gui);
            this.spinnerV = new Spinner(gui);
            this.hexField = new TextField(gui);
            int r = (ColorButton.this.color & 0xFF0000) >> 16;
            int g = (ColorButton.this.color & 0xFF00) >> 8;
            int b = ColorButton.this.color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.updateColorRGB_spinner();
            this.sliderR.setBounds(new Box(5, 120, 100, 20));
            this.sliderG.setBounds(new Box(5, 150, 100, 20));
            this.sliderB.setBounds(new Box(5, 180, 100, 20));
            this.sliderH.setBounds(new Box(5, 30, 100, 20));
            this.sliderS.setBounds(new Box(5, 60, 100, 20));
            this.sliderV.setBounds(new Box(5, 90, 100, 20));
            this.spinnerR.setBounds(new Box(110, 120, 40, 20));
            this.spinnerG.setBounds(new Box(110, 150, 40, 20));
            this.spinnerB.setBounds(new Box(110, 180, 40, 20));
            this.spinnerH.setBounds(new Box(110, 30, 40, 20));
            this.spinnerS.setBounds(new Box(110, 60, 40, 20));
            this.spinnerV.setBounds(new Box(110, 90, 40, 20));
            this.hexField.setBounds(new Box(5, 210, 100, 20));
            this.spinnerR.setDp(0);
            this.spinnerG.setDp(0);
            this.spinnerB.setDp(0);
            this.spinnerH.setDp(0);
            this.spinnerS.setDp(0);
            this.spinnerV.setDp(0);
            this.sliderR.setAction(this::updateColorRGB_slider);
            this.sliderG.setAction(this::updateColorRGB_slider);
            this.sliderB.setAction(this::updateColorRGB_slider);
            this.sliderH.setAction(this::updateColorHSV_slider);
            this.sliderS.setAction(this::updateColorHSV_slider);
            this.sliderV.setAction(this::updateColorHSV_slider);
            this.spinnerR.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerG.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerB.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerH.addChangeListener(this::updateColorHSV_spinner);
            this.spinnerS.addChangeListener(this::updateColorHSV_spinner);
            this.spinnerV.addChangeListener(this::updateColorHSV_spinner);
            this.hexField.setEventListener(this::updateHexField);
            this.addElement(this.sliderR);
            this.addElement(this.sliderG);
            this.addElement(this.sliderB);
            this.addElement(this.spinnerR);
            this.addElement(this.spinnerG);
            this.addElement(this.spinnerB);
            this.addElement(this.sliderH);
            this.addElement(this.sliderS);
            this.addElement(this.sliderV);
            this.addElement(this.spinnerH);
            this.addElement(this.spinnerS);
            this.addElement(this.spinnerV);
            this.addElement(this.hexField);
            Button ok = new Button(gui, gui.i18nFormat("button.cpm.set", new Object[0]), () -> {
                int color = this.getColor();
                colorCache.remove((Object)color);
                if (colorCache.size() >= 6) {
                    colorCache.remove(0);
                }
                colorCache.add(color);
                ColorButton.this.actionColor.accept(color);
                this.close();
            });
            ok.setBounds(new Box(5, 265, 100, 16));
            this.addElement(ok);
            for (int i = 0; i < 6; ++i) {
                int c = i < colorCache.size() ? (Integer)colorCache.get(colorCache.size() - i - 1) : -1;
                ColorButton btn = new ColorButton(gui, () -> this.loadColor(c));
                btn.setColor(c);
                btn.setBounds(new Box(5 + i * 25, 240, 20, 16));
                this.addElement(btn);
            }
            this.setBounds(new Box(0, 0, 160, 290));
            this.updateDisplayText();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 35, this.bounds.y + 5, 30, 20, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 34, this.bounds.y + 6, 28, 18, this.getColor() | 0xFF000000);
        }

        private void loadColor(int color) {
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.sliderR.setValue((float)r / 255.0f);
            this.sliderG.setValue((float)g / 255.0f);
            this.sliderB.setValue((float)b / 255.0f);
            this.updateRGB();
            this.updateDisplayText();
            this.hexField.setText(String.format("%1$06X", color));
        }

        private int getColor() {
            return ((int)(this.sliderR.getValue() * 255.0f) & 0xFF) << 16 | ((int)(this.sliderG.getValue() * 255.0f) & 0xFF) << 8 | (int)(this.sliderB.getValue() * 255.0f) & 0xFF;
        }

        private void updateColorRGB_spinner() {
            this.sliderR.setValue(this.spinnerR.getValue() / 255.0f);
            this.sliderG.setValue(this.spinnerG.getValue() / 255.0f);
            this.sliderB.setValue(this.spinnerB.getValue() / 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
            this.updateRGB();
            this.updateDisplayText();
        }

        private void updateColorHSV_spinner() {
            this.sliderH.setValue(this.spinnerH.getValue() / 360.0f);
            this.sliderS.setValue(this.spinnerS.getValue() / 100.0f);
            this.sliderV.setValue(this.spinnerV.getValue() / 100.0f);
            this.updateHSV();
            this.updateDisplayText();
        }

        private void updateRGB() {
            float[] hsv = Color.RGBtoHSB((int)this.spinnerR.getValue(), (int)this.spinnerG.getValue(), (int)this.spinnerB.getValue(), null);
            this.sliderH.setValue(hsv[0]);
            this.sliderS.setValue(hsv[1]);
            this.sliderV.setValue(hsv[2]);
            this.spinnerH.setValue(hsv[0] * 360.0f);
            this.spinnerS.setValue(hsv[1] * 100.0f);
            this.spinnerV.setValue(hsv[2] * 100.0f);
        }

        private void updateHSV() {
            int color = Color.HSBtoRGB(this.sliderH.getValue(), this.sliderS.getValue(), this.sliderV.getValue());
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.sliderR.setValue((float)r / 255.0f);
            this.sliderG.setValue((float)g / 255.0f);
            this.sliderB.setValue((float)b / 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
        }

        private void updateColorRGB_slider() {
            this.spinnerR.setValue(this.sliderR.getValue() * 255.0f);
            this.spinnerG.setValue(this.sliderG.getValue() * 255.0f);
            this.spinnerB.setValue(this.sliderB.getValue() * 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
            this.updateRGB();
            this.updateDisplayText();
        }

        private void updateColorHSV_slider() {
            this.spinnerH.setValue(this.sliderH.getValue() * 360.0f);
            this.spinnerS.setValue(this.sliderS.getValue() * 100.0f);
            this.spinnerV.setValue(this.sliderV.getValue() * 100.0f);
            this.updateHSV();
            this.updateDisplayText();
        }

        private void updateDisplayText() {
            this.sliderR.setText("R: " + (int)(this.sliderR.getValue() * 255.0f));
            this.sliderG.setText("G: " + (int)(this.sliderG.getValue() * 255.0f));
            this.sliderB.setText("B: " + (int)(this.sliderB.getValue() * 255.0f));
            this.sliderH.setText("H: " + (int)(this.sliderH.getValue() * 360.0f));
            this.sliderS.setText("S: " + (int)(this.sliderS.getValue() * 100.0f));
            this.sliderV.setText("V: " + (int)(this.sliderV.getValue() * 100.0f));
            int color = this.getColor();
            this.sliderR.setColor(color & 0xFFFF | 0xFF000000, color | 0xFF0000);
            this.sliderG.setColor(color & 0xFF00FF | 0xFF000000, color | 0xFF00);
            this.sliderB.setColor(color & 0xFFFF00 | 0xFF000000, color | 0xFF);
            int hsv = ColorButton.rgb2hsv(color);
            this.sliderH.setColor(0, hsv);
            this.sliderS.setColor(ColorButton.hsv2rgb(hsv & 0xFF00FF) | 0xFF000000, ColorButton.hsv2rgb(hsv | 0xFF00));
            this.sliderV.setColor(ColorButton.hsv2rgb(hsv & 0xFFFF00) | 0xFF000000, ColorButton.hsv2rgb(hsv | 0xFF));
        }

        private void updateHexField() {
            try {
                int color = Integer.parseInt(this.hexField.getText(), 16);
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                this.spinnerR.setValue(r);
                this.spinnerG.setValue(g);
                this.spinnerB.setValue(b);
                this.sliderR.setValue((float)r / 255.0f);
                this.sliderG.setValue((float)g / 255.0f);
                this.sliderB.setValue((float)b / 255.0f);
                this.updateRGB();
                this.updateDisplayText();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.changeColor", new Object[0]);
        }
    }
}

