/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.model.render.VanillaPlayerModel;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class ViewportPanel
extends ViewportPanelBase3d {
    protected Editor editor;

    public ViewportPanel(IGui gui, Editor editor) {
        super(gui);
        this.editor = editor;
    }

    @Override
    public void render(MatrixStack stack, VBuffers buf, float partialTicks) {
        if (this.editor.renderBase) {
            this.renderBase(stack, buf);
        }
        this.renderModel(stack, buf, partialTicks);
    }

    @Override
    public ViewportCamera getCamera() {
        return this.editor.camera;
    }

    @Override
    public void preRender() {
        this.editor.preRender();
    }

    @Override
    public ModelDefinition getDefinition() {
        return this.editor.definition;
    }

    @Override
    public boolean applyLighting() {
        return true;
    }

    @Override
    public DisplayItem getHeldItem(ItemSlot hand) {
        return this.editor.handDisplay.getOrDefault((Object)hand, DisplayItem.NONE);
    }

    @Override
    public float getScale() {
        return this.editor.applyScaling ? this.editor.scaling : 1.0f;
    }

    @Override
    public AnimationEngine.AnimationMode getAnimMode() {
        return AnimationEngine.AnimationMode.PLAYER;
    }

    @Override
    public Set<PlayerModelLayer> getArmorLayers() {
        PlayerModelLayer l;
        ModelElement root;
        ModelElement el = this.editor.getSelectedElement();
        if (el != null && (root = el.getRoot()) != null && root.typeData instanceof RootModelType && (l = PlayerModelLayer.getLayer((RootModelType)root.typeData)) != null) {
            HashSet<PlayerModelLayer> set = new HashSet<PlayerModelLayer>(this.editor.modelDisplayLayers);
            set.add(l);
            return set;
        }
        return this.editor.modelDisplayLayers;
    }

    @Override
    protected void poseModel(VanillaPlayerModel p, MatrixStack matrixstack, float partialTicks) {
        p.reset();
        p.setAllVisible(true);
        ViewportPanel.setHeldItem(this, ItemSlot.RIGHT_HAND, ap -> {
            p.rightArmPose = ap;
        });
        ViewportPanel.setHeldItem(this, ItemSlot.LEFT_HAND, ap -> {
            p.leftArmPose = ap;
        });
        PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, Hand.RIGHT, false);
        if (!this.editor.applyAnim && this.editor.playerTpose) {
            p.rightArm.zRot = (float)Math.toRadians(90.0);
            p.leftArm.zRot = (float)Math.toRadians(-90.0);
        }
        float lsa = 0.75f;
        float ls = this.editor.playVanillaAnims || this.editor.selectedAnim == null ? (float)MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTicks() * 0.2f - 1.5f * (1.0f - partialTicks) : 1.0f;
        this.editor.applyRenderPoseForAnim(pose -> {
            switch (pose) {
                case SLEEPING: {
                    matrixstack.translate(0.0, 1.501f, 0.0);
                    matrixstack.rotate(Vec3f.POSITIVE_Z.getDegreesQuaternion(-90.0f));
                    matrixstack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(270.0f));
                    break;
                }
                case SNEAKING: {
                    p.crouching = true;
                    PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, Hand.RIGHT, false);
                    break;
                }
                case RIDING: {
                    p.riding = true;
                    PlayerModelSetup.setRotationAngles(p, 0.0f, 0.0f, Hand.RIGHT, false);
                    break;
                }
                case CUSTOM: 
                case DYING: 
                case FALLING: 
                case STANDING: {
                    break;
                }
                case FLYING: {
                    matrixstack.translate(0.0, 1.0, -0.5);
                    matrixstack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(90.0f));
                    p.head.xRot = -0.7853982f;
                    break;
                }
                case RUNNING: {
                    PlayerModelSetup.setRotationAngles(p, ls, 1.0f, Hand.RIGHT, false);
                    break;
                }
                case SWIMMING: {
                    PlayerModelSetup.setRotationAngles(p, ls, lsa, Hand.RIGHT, true);
                    matrixstack.translate(0.0, 1.0, -0.5);
                    matrixstack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(90.0f));
                    break;
                }
                case WALKING: {
                    PlayerModelSetup.setRotationAngles(p, ls, lsa, Hand.RIGHT, false);
                    break;
                }
                case SKULL_RENDER: {
                    p.setAllVisible(false);
                    p.head.visible = true;
                    matrixstack.translate(0.0, 1.501f, 0.0);
                    break;
                }
            }
        });
    }

    private static void setHeldItem(ViewportPanelBase3d panel, ItemSlot hand, Consumer<PlayerModelSetup.ArmPose> pose) {
        switch (panel.getHeldItem(hand)) {
            case BLOCK: 
            case SWORD: 
            case SKULL: {
                pose.accept(PlayerModelSetup.ArmPose.ITEM);
                break;
            }
            default: {
                pose.accept(PlayerModelSetup.ArmPose.EMPTY);
            }
        }
    }
}

