/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.TextureDisplay;
import java.util.function.Supplier;

public class TextureEditorPanel
extends GuiElement {
    private int lastMx;
    private int lastMy;
    private boolean dragging;
    private float zoom;
    private int offX;
    private int offY;
    private int dragX;
    private int dragY;
    private Editor editor;
    public Supplier<Vec2i> cursorPos;
    private Vec2i mouseCursorPos = new Vec2i();
    private Vec2i moveStart = new Vec2i();

    public TextureEditorPanel(IGui gui, Editor editor, int zoom) {
        super(gui);
        this.editor = editor;
        this.zoom = 0.0f;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.mouseCursorPos.x = event.x;
        this.mouseCursorPos.y = event.y;
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.bounds);
        this.gui.setupCut();
        ETextures provider = this.editor.getTextureProvider();
        if (provider != null) {
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.gui.getColors().button_fill);
            provider.provider.bind();
            if (this.zoom == 0.0f) {
                this.zoom = (float)this.bounds.h / (float)provider.getImage().getWidth();
            }
            int rw = (int)(this.zoom * (float)provider.getImage().getWidth());
            int rh = (int)(this.zoom * (float)provider.getImage().getHeight());
            this.gui.drawBox(this.offX, this.offY, rw, rh, -1);
            this.gui.drawTexture(this.offX, this.offY, rw, rh, 0.0f, 0.0f, 1.0f, 1.0f);
            int imgX = (int)((float)(event.x - this.offX - this.bounds.x) / this.zoom);
            int imgY = (int)((float)(event.y - this.offY - this.bounds.y) / this.zoom);
            TextureDisplay.drawBoxTextureOverlay(this.gui, this.editor, this.offX, this.offY, this.zoom, this.zoom);
            Vec2i p1 = event.isHovered(this.bounds) && imgX >= 0 && imgY >= 0 && imgX < provider.getImage().getWidth() && imgY < provider.getImage().getHeight() ? new Vec2i(imgX, imgY) : null;
            switch (this.editor.drawMode) {
                case MOVE_UV: {
                    if (p1 == null) break;
                    ModelElement e = this.getElementUnderMouse(p1.x, p1.y);
                    if (this.dragging) {
                        e = this.editor.getSelectedElement();
                    }
                    if (e == null) break;
                    Box b = e.getTextureBox();
                    this.gui.drawRectangle((float)b.x * this.zoom + (float)this.offX, (float)b.y * this.zoom + (float)this.offY, (float)b.w * this.zoom, (float)b.h * this.zoom, -16777216);
                    break;
                }
                case PEN: 
                case RUBBER: {
                    Vec2i p;
                    Vec2i p2 = this.editor.cursorPos.get();
                    Vec2i vec2i = p = p2 != null ? p2 : p1;
                    if (!provider.isEditable() || p == null || p.x < 0 || p.y < 0 || p.x >= provider.getImage().getWidth() || p.y >= provider.getImage().getHeight()) break;
                    int imgC = provider.getImage().getRGB(p.x, p.y);
                    int outlineColor = 0xFFFFFF - (imgC & 0xFFFFFF) & 0xFFFFFF;
                    int a = imgC >> 24 & 0xFF;
                    if (a < 64) {
                        outlineColor = 0;
                    }
                    if (a == 0) {
                        imgC = -1;
                    }
                    this.gui.drawBox((float)p.x * this.zoom + (float)this.offX, (float)p.y * this.zoom + (float)this.offY, this.zoom, this.zoom, 0xFF000000 | outlineColor);
                    this.gui.drawBox((float)p.x * this.zoom + (float)this.offX + 1.0f, (float)p.y * this.zoom + (float)this.offY + 1.0f, this.zoom - 2.0f, this.zoom - 2.0f, -16777216);
                    this.gui.drawBox((float)p.x * this.zoom + (float)this.offX + 1.0f, (float)p.y * this.zoom + (float)this.offY + 1.0f, this.zoom - 2.0f, this.zoom - 2.0f, imgC);
                    break;
                }
            }
        }
        this.gui.popMatrix();
    }

    private ModelElement getElementUnderMouse(int x, int y) {
        ModelElement[] elem = new ModelElement[1];
        Editor.walkElements(this.editor.elements, e -> {
            if (elem[0] != null) {
                return;
            }
            if (e.type != ElementType.NORMAL) {
                return;
            }
            Box b = e.getTextureBox();
            if (b != null && b.isInBounds(x, y)) {
                elem[0] = e;
            }
        });
        return elem[0];
    }

    @Override
    public boolean mouseWheel(int x, int y, int dir) {
        if (this.bounds.isInBounds(x, y)) {
            this.zoom(x, y, dir);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClick(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y)) {
            this.lastMx = x;
            this.lastMy = y;
            this.dragging = true;
            ETextures provider = this.editor.getTextureProvider();
            if (btn == 0) {
                int px = (int)((float)(x - this.offX - this.bounds.x) / this.zoom);
                int py = (int)((float)(y - this.offY - this.bounds.y) / this.zoom);
                if (px >= 0 && py >= 0 && px < provider.getImage().getWidth() && py < provider.getImage().getHeight()) {
                    switch (this.editor.drawMode) {
                        case PEN: 
                        case RUBBER: 
                        case FILL: {
                            if (this.gui.isCtrlDown()) {
                                this.editor.penColor = provider.getImage().getRGB(px, py);
                                this.editor.setPenColor.accept(this.editor.penColor);
                                this.dragging = false;
                                break;
                            }
                            this.editor.drawPixel(px, py, false);
                            break;
                        }
                        case MOVE_UV: {
                            this.dragX = px;
                            this.dragY = py;
                            ModelElement me = this.getElementUnderMouse(px, py);
                            this.editor.selectedElement = me;
                            if (me == null) break;
                            this.moveStart.x = me.u;
                            this.moveStart.y = me.v;
                            break;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDrag(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y)) {
            if (this.dragging) {
                int dx = x - this.lastMx;
                int dy = y - this.lastMy;
                ETextures provider = this.editor.getTextureProvider();
                if (btn == EditorGui.getRotateMouseButton()) {
                    this.offX += dx;
                    this.offY += dy;
                    this.offX = MathHelper.clamp(this.offX, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.w - 10);
                    this.offY = MathHelper.clamp(this.offY, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.h - 10);
                } else if (btn == 0) {
                    int px = (int)((float)(x - this.offX - this.bounds.x) / this.zoom);
                    int py = (int)((float)(y - this.offY - this.bounds.y) / this.zoom);
                    if (px >= 0 && py >= 0 && px < provider.getImage().getWidth() && py < provider.getImage().getHeight()) {
                        switch (this.editor.drawMode) {
                            case PEN: 
                            case RUBBER: 
                            case FILL: {
                                this.editor.drawPixel(px, py, false);
                                break;
                            }
                            case MOVE_UV: {
                                ModelElement me = this.editor.getSelectedElement();
                                if (me == null) break;
                                int xoff = px - this.dragX;
                                int yoff = py - this.dragY;
                                if (Math.abs(xoff) >= me.textureSize) {
                                    this.dragX = px;
                                }
                                if (Math.abs(yoff) >= me.textureSize) {
                                    this.dragY = py;
                                }
                                me.u = MathHelper.clamp(me.u + xoff / me.textureSize, 0, provider.provider.size.x);
                                me.v = MathHelper.clamp(me.v + yoff / me.textureSize, 0, provider.provider.size.y);
                                if (xoff <= 0 && yoff <= 0) break;
                                this.editor.updateGui();
                                this.editor.markDirty();
                                break;
                            }
                        }
                    }
                }
                this.lastMx = x;
                this.lastMy = y;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseRelease(int x, int y, int btn) {
        if (this.bounds.isInBounds(x, y) || this.dragging) {
            this.dragging = false;
            switch (this.editor.drawMode) {
                case MOVE_UV: {
                    ModelElement me = this.editor.getSelectedElement();
                    if (me == null) break;
                    this.editor.action("move", "action.cpm.texUV").updateValueOp(me, new Vec2i(this.moveStart), new Vec2i(me.u, me.v), (a, b) -> {
                        a.u = b.x;
                        a.v = b.y;
                    }).execute();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void zoom(int x, int y, int dir) {
        ETextures provider = this.editor.getTextureProvider();
        float zv = (float)dir * (this.zoom / 8.0f);
        float iw = (float)provider.getImage().getWidth() * this.zoom;
        float ih = (float)provider.getImage().getHeight() * this.zoom;
        this.zoom += zv;
        float niw = (float)provider.getImage().getWidth() * this.zoom;
        float nih = (float)provider.getImage().getHeight() * this.zoom;
        this.offX = (int)((float)this.offX - (niw - iw) / 2.0f * (float)MathHelper.clamp(Math.abs(1 - this.offX / (this.bounds.w / 2)), 0, 1));
        this.offY = (int)((float)this.offY - (nih - ih) / 2.0f * (float)MathHelper.clamp(Math.abs(1 - this.offY / (this.bounds.h / 2)), 0, 1));
        this.offX = MathHelper.clamp(this.offX, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.w - 10);
        this.offY = MathHelper.clamp(this.offY, (int)((float)(-provider.getImage().getWidth()) * this.zoom + 10.0f), this.bounds.h - 10);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (!event.isConsumed() && this.bounds.isInBounds(this.mouseCursorPos)) {
            if (event.matches("+")) {
                this.zoom(this.mouseCursorPos.x, this.mouseCursorPos.y, 1);
            } else if (event.matches("-")) {
                this.zoom(this.mouseCursorPos.x, this.mouseCursorPos.y, -1);
            }
        }
    }
}

