/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupMenu;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ButtonGroup;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.DisplayItem;
import com.tom.cpm.shared.editor.ETextures;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.Generators;
import com.tom.cpm.shared.editor.RootGroups;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.AnimPanel;
import com.tom.cpm.shared.editor.gui.AnimTestPanel;
import com.tom.cpm.shared.editor.gui.DrawToolsPanel;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.gui.TestIngameManager;
import com.tom.cpm.shared.editor.gui.TextureEditorPanel;
import com.tom.cpm.shared.editor.gui.TreePanel;
import com.tom.cpm.shared.editor.gui.ViewportPaintPanel;
import com.tom.cpm.shared.editor.gui.ViewportPanel;
import com.tom.cpm.shared.editor.gui.ViewportPanelAnim;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import com.tom.cpm.shared.editor.gui.popup.DescPopup;
import com.tom.cpm.shared.editor.gui.popup.ExportSkinPopup;
import com.tom.cpm.shared.editor.gui.popup.ModelsPopup;
import com.tom.cpm.shared.editor.gui.popup.SettingsPopup;
import com.tom.cpm.shared.editor.template.EditorTemplate;
import com.tom.cpm.shared.editor.template.TemplateSettings;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.io.File;
import java.util.Arrays;

public class EditorGui
extends Frame {
    public static boolean rescaleGui = true;
    private static Editor toReopen;
    private TabbedPanelManager tabs;
    private HorizontalLayout topPanel;
    private Editor editor;
    private static boolean smallGuiWarning;
    private static boolean notSupportedWarning;

    public EditorGui(IGui gui) {
        super(gui);
        if (toReopen != null) {
            this.editor = toReopen;
            this.editor.setGui(this);
            toReopen = null;
            ModConfig.getCommonConfig().clearValue("reopenProject");
            ModConfig.getCommonConfig().save();
        } else {
            this.editor = new Editor();
            this.editor.setGui(this);
            String reopen = ModConfig.getCommonConfig().getString("reopenProject", null);
            if (reopen != null) {
                ModConfig.getCommonConfig().clearValue("reopenProject");
                ModConfig.getCommonConfig().save();
                this.load(new File(reopen));
            } else {
                this.editor.loadDefaultPlayerModel();
            }
        }
        TestIngameManager.checkConfig();
        gui.setCloseListener(c -> this.checkUnsaved(() -> {
            this.editor.free();
            c.run();
        }));
    }

    private void checkUnsaved(Runnable r) {
        if (this.editor.dirty) {
            this.openPopup(new ConfirmPopup(this, this.gui.i18nFormat("label.cpm.unsaved", new Object[0]), r, null));
        } else {
            r.run();
        }
    }

    @Override
    public void initFrame(int width, int height) {
        int scale = ModConfig.getCommonConfig().getInt("editorScale", -1);
        if (scale != -1 && rescaleGui && this.gui.getScale() != scale) {
            this.gui.setScale(scale);
            return;
        }
        this.editor.updaterReg.reset();
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 20));
        this.addElement(this.tabs);
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        this.initFileMenu();
        this.initEditMenu();
        this.initEffectMenu();
        this.initDisplayMenu();
        this.topPanel.addX(2);
        this.initModelPanel(width, height);
        this.initTexturePanel(width, height);
        this.initAnimPanel(width, height);
        Label title = new Label(this.gui, "");
        this.editor.setNameDisplay.add(title::setText);
        title.setBounds(new Box(5, 8, 0, 0));
        this.topPanel.add(title);
        this.editor.updateGui();
        if (smallGuiWarning && (height < 420 || width < 500)) {
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.gui_scale_too_large", new Object[0])));
        }
        smallGuiWarning = false;
        if (notSupportedWarning && !PlatformFeature.EDITOR_SUPPORTED.isSupported()) {
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.warning", new Object[0]), this.gui.i18nFormat("label.cpm.editor_not_supported", new Object[0])));
        }
        notSupportedWarning = false;
    }

    private void initModelPanel(int width, int height) {
        Panel mainPanel = new Panel(this.gui);
        mainPanel.setBounds(new Box(0, 0, width, height - 20));
        ScrollPanel sp = new ScrollPanel(this.gui);
        sp.setDisplay(new PosPanel(this.gui, this));
        sp.setBounds(new Box(0, 0, 170, height - 20));
        sp.setScrollBarSide(true);
        mainPanel.addElement(sp);
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.model", new Object[0]), mainPanel));
        mainPanel.addElement(new TreePanel(this.gui, this, width, height - 20, true));
        ViewportPanel view = new ViewportPanel(this.gui, this.editor);
        view.setBounds(new Box(170, 0, width - 170 - 150, height - 20));
        mainPanel.addElement(view);
        this.editor.displayViewport.add(view::setEnabled);
        this.editor.heldRenderEnable.accept(PlatformFeature.EDITOR_HELD_ITEM.isSupported());
    }

    private void initTexturePanel(int width, int height) {
        Panel textureEditor = new Panel(this.gui);
        textureEditor.setBounds(new Box(0, 0, width, height - 20));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.texture", new Object[0]), textureEditor));
        ViewportPaintPanel viewT = new ViewportPaintPanel(this.gui, this.editor);
        viewT.setBounds(new Box(0, 0, width - height / 2, height - 20));
        textureEditor.addElement(viewT);
        this.editor.cursorPos = viewT::getHoveredTexPos;
        this.editor.displayViewport.add(viewT::setEnabled);
        TextureEditorPanel tdp = new TextureEditorPanel(this.gui, this.editor, height / 2);
        tdp.setBounds(new Box(width - height / 2, 0, height / 2, height / 2));
        textureEditor.addElement(tdp);
        int treeW = Math.min(150, height / 2);
        TreePanel treePanel = new TreePanel(this.gui, this, treeW, height / 2 - 20, false);
        treePanel.setBounds(new Box(width - treeW, height / 2, treeW, height / 2));
        textureEditor.addElement(treePanel);
        textureEditor.addElement(new DrawToolsPanel(this, width - height / 2, height / 2, height / 2 - treeW, height / 2));
    }

    private void initAnimPanel(int width, int height) {
        Panel mainPanel = new Panel(this.gui);
        mainPanel.setBounds(new Box(0, 0, width, height - 20));
        Panel buttonsPanel = new Panel(this.gui);
        buttonsPanel.setBounds(new Box(0, 0, 170, 20));
        buttonsPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        HorizontalLayout buttons = new HorizontalLayout(buttonsPanel);
        TabbedPanelManager animPanelTabs = new TabbedPanelManager(this.gui);
        ScrollPanel spSetup = new ScrollPanel(this.gui);
        spSetup.setBounds(new Box(0, 0, 170, height - 40));
        spSetup.setDisplay(new AnimPanel(this.gui, this));
        spSetup.setScrollBarSide(true);
        ScrollPanel spTest = new ScrollPanel(this.gui);
        spTest.setBounds(new Box(0, 0, 170, height - 40));
        spTest.setDisplay(new AnimTestPanel(this.gui, this));
        spTest.setScrollBarSide(true);
        buttons.add(animPanelTabs.createTab(this.gui.i18nFormat("tab.cpm.animation.setup", new Object[0]), spSetup));
        buttons.add(animPanelTabs.createTab(this.gui.i18nFormat("tab.cpm.animation.test", new Object[0]), spTest));
        animPanelTabs.setBounds(new Box(0, 20, 170, height - 40));
        mainPanel.addElement(animPanelTabs);
        mainPanel.addElement(buttonsPanel);
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.animation", new Object[0]), mainPanel));
        mainPanel.addElement(new TreePanel(this.gui, this, width, height - 20, false){

            @Override
            public void draw(MouseEvent event, float partialTicks) {
                ((EditorGui)EditorGui.this).editor.applyAnim = true;
                super.draw(event, partialTicks);
                ((EditorGui)EditorGui.this).editor.applyAnim = false;
            }
        });
        ViewportPanelAnim view = new ViewportPanelAnim(this.gui, this.editor);
        view.setBounds(new Box(170, 0, width - 170 - 150, height - 20));
        mainPanel.addElement(view);
        this.editor.displayViewport.add(view::setEnabled);
    }

    private void newModel(SkinType type) {
        this.checkUnsaved(() -> {
            this.editor.loadDefaultPlayerModel();
            this.editor.customSkinType = true;
            this.editor.skinType = type;
            this.editor.updateGui();
        });
    }

    private void initFileMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.file", new Object[0]), () -> pp.display(0, 20)));
        PopupMenu newMenu = new PopupMenu(this.gui, this);
        PopupMenu newModelMenu = new PopupMenu(this.gui, this);
        newMenu.addMenuButton(this.gui.i18nFormat("button.cpm.new.model", new Object[0]), newModelMenu);
        for (SkinType type : SkinType.VALUES) {
            if (type == SkinType.UNKNOWN) continue;
            newModelMenu.addButton(this.gui.i18nFormat("label.cpm.skin_type." + type.getName(), new Object[0]), () -> this.newModel(type));
        }
        Button newTempl = newMenu.addButton(this.gui.i18nFormat("button.cpm.new.template", new Object[0]), () -> this.checkUnsaved(() -> {
            this.editor.loadDefaultPlayerModel();
            this.editor.templateSettings = new TemplateSettings(this.editor);
            Generators.setupTemplateModel(this.editor);
            ETextures skin = this.editor.textures.get((Object)TextureSheetType.SKIN);
            skin.setImage(new Image(64, 64));
            skin.markDirty();
            this.editor.updateGui();
        }));
        newTempl.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.new.template", new Object[0])));
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.file.new", new Object[0]), newMenu);
        pp.addButton(this.gui.i18nFormat("button.cpm.file.load", new Object[0]), () -> this.checkUnsaved(() -> {
            FileChooserPopup fc = new FileChooserPopup(this);
            fc.setTitle(this.gui.i18nFormat("label.cpm.loadFile", new Object[0]));
            fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_project", new Object[0]));
            fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
            fc.setAccept(this::load);
            fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
            this.openPopup(fc);
        }));
        pp.addButton(this.gui.i18nFormat("button.cpm.file.save", new Object[0]), this::save);
        pp.addButton(this.gui.i18nFormat("button.cpm.file.saveAs", new Object[0]), this::saveAs);
        PopupMenu importMenu = new PopupMenu(this.gui, this);
        importMenu.addButton(this.gui.i18nFormat("button.cpm.file.import.project", new Object[0]), () -> {
            FileChooserPopup fc = new FileChooserPopup(this);
            fc.setTitle(this.gui.i18nFormat("button.cpm.file.import", new Object[0]));
            fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_project", new Object[0]));
            fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
            fc.setAccept(f -> {});
            fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
            this.openPopup(fc);
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.file.export", new Object[0]), () -> this.openPopup(ExportSkinPopup.createPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.file.test", new Object[0]), () -> {
            if (TestIngameManager.openTestIngame(this)) {
                toReopen = this.editor;
            }
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.file.exit", new Object[0]), this.gui::close);
    }

    private void save() {
        if (this.editor.file != null) {
            this.saveProject(this.editor.file);
        } else {
            this.saveAs();
        }
    }

    private void saveAs() {
        FileChooserPopup fc = new FileChooserPopup(this);
        fc.setTitle(this.gui.i18nFormat("label.cpm.saveFile", new Object[0]));
        fc.setFileDescText(this.gui.i18nFormat("label.cpm.file_project", new Object[0]));
        fc.setFilter(new FileChooserPopup.FileFilter("cpmproject"));
        fc.setSaveDialog(true);
        fc.setExtAdder(n -> n + ".cpmproject");
        fc.setAccept(this::saveProject);
        fc.setButtonText(this.gui.i18nFormat("button.cpm.ok", new Object[0]));
        this.openPopup(fc);
    }

    private void initEditMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.edit", new Object[0]), () -> pp.display(x, 20)));
        Button undo = pp.addButton(this.gui.i18nFormat("button.cpm.edit.undo", new Object[0]), this.editor::undo);
        this.editor.setUndo.add(t -> {
            undo.setEnabled(t != null);
            undo.setText(t == null || t.isEmpty() ? this.gui.i18nFormat("button.cpm.edit.undo", new Object[0]) : this.gui.i18nFormat("button.cpm.edit.undoAction", t));
        });
        Button redo = pp.addButton(this.gui.i18nFormat("button.cpm.edit.redo", new Object[0]), this.editor::redo);
        this.editor.setRedo.add(t -> {
            redo.setEnabled(t != null);
            redo.setText(t == null || t.isEmpty() ? this.gui.i18nFormat("button.cpm.edit.redo", new Object[0]) : this.gui.i18nFormat("button.cpm.edit.redoAction", t));
        });
        PopupMenu tools = new PopupMenu(this.gui, this);
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.edit.tools", new Object[0]), tools);
        Generators.generators.forEach(g -> {
            Button btn = tools.addButton(this.gui.i18nFormat(g.name, new Object[0]), () -> g.func.accept(this));
            if (g.tooltip != null) {
                btn.setTooltip(new Tooltip(this, this.gui.i18nFormat(g.tooltip, new Object[0])));
            }
        });
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.add_template", new Object[0]), new InputPopup(this, this.gui.i18nFormat("label.cpm.template_link_input", new Object[0]), this.gui.i18nFormat("label.cpm.template_link_input.desc", new Object[0]), link -> new ProcessPopup<EditorTemplate>(this, this.gui.i18nFormat("label.cpm.loading_template", new Object[0]), this.gui.i18nFormat("label.cpm.loading_template.desc", new Object[0]), () -> EditorTemplate.create(this.editor, link), t -> {
            this.editor.templates.add((EditorTemplate)t);
            this.editor.restitchTextures();
            this.editor.markDirty();
            this.editor.updateGui();
        }, e -> {
            if (e == null) {
                return;
            }
            Log.warn("Failed to download template", e);
            this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.template_load_error", e.getMessage())));
        }).start(), null));
        pp.addButton(this.gui.i18nFormat("label.cpm.desc", new Object[0]), () -> this.openPopup(new DescPopup(this)));
        PopupMenu parts = new PopupMenu(this.gui, this);
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.edit.parts", new Object[0]), parts);
        RootGroups.forEach(c -> parts.addButton(this.gui.i18nFormat("button.cpm.root_group." + c.name().toLowerCase(), new Object[0]), () -> this.editor.addRoot((RootGroups)((Object)c))));
        parts.addButton(this.gui.i18nFormat("button.cpm.root_group.itemHoldPos", new Object[0]), () -> Generators.addItemHoldPos(this.editor));
        pp.add(new Label(this.gui, "=========").setBounds(new Box(5, 5, 0, 0)));
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.settings", new Object[0]), () -> this.openPopup(new SettingsPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.models", new Object[0]), () -> this.openPopup(new ModelsPopup(this)));
        pp.addButton(this.gui.i18nFormat("button.cpm.edit.controls", new Object[0]), () -> this.openPopup(new MessagePopup(this, this.gui.i18nFormat("button.cpm.edit.controls", new Object[0]), this.gui.i18nFormat("label.cpm.controls.text", new Object[0]))));
    }

    private void initEffectMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.effect", new Object[0]), () -> pp.display(x, 20)));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.effect.cubeEffects", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        Checkbox boxGlow = pp.addCheckbox(this.gui.i18nFormat("label.cpm.glow", new Object[0]), this.editor::switchGlow);
        this.editor.setGlow.add(boxGlow::updateState);
        boxGlow.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.glow", new Object[0])));
        Checkbox boxSingleTex = pp.addCheckbox(this.gui.i18nFormat("label.cpm.singleTex", new Object[0]), this.editor::switchSingleTex);
        this.editor.setSingleTex.add(boxSingleTex::updateState);
        boxSingleTex.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.singleTex", new Object[0])));
        Checkbox boxPfUV = pp.addCheckbox(this.gui.i18nFormat("label.cpm.perfaceUV", new Object[0]), this.editor::switchPerfaceUV);
        this.editor.setPerFaceUV.add(boxPfUV::updateState);
        boxPfUV.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.perfaceUV", new Object[0])));
        Checkbox boxReColor = pp.addCheckbox(this.gui.i18nFormat("label.cpm.recolor", new Object[0]), this.editor::switchReColorEffect);
        this.editor.setReColor.add(boxReColor::updateState);
        boxReColor.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.recolor", new Object[0])));
        ColorButton colorBtn = new ColorButton(this.gui, this.editor.frame, this.editor::setColor);
        this.editor.setPartColor.add(c -> {
            colorBtn.setEnabled(c != null);
            if (c != null) {
                colorBtn.setColor((int)c);
            } else {
                colorBtn.setColor(0);
            }
        });
        colorBtn.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.recolor.colorbtn", new Object[0])));
        pp.add(colorBtn);
        Checkbox boxHidden = pp.addCheckbox(this.gui.i18nFormat("label.cpm.hidden_effect", new Object[0]), this.editor::switchHide);
        this.editor.setHiddenEffect.add(boxHidden::updateState);
        boxHidden.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.hidden_effect", new Object[0])));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.effect.modelEffects", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        Checkbox chxbxScale = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.scaling", new Object[0]), () -> {
            float nv = this.editor.scaling != 0.0f ? 0.0f : 1.0f;
            this.editor.action("switch", "label.cpm.display.scaling").updateValueOp(this.editor, Float.valueOf(this.editor.scaling), Float.valueOf(nv), (a, b) -> {
                a.scaling = b.floatValue();
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> chxbxScale.setSelected(this.editor.scaling != 0.0f));
        chxbxScale.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.scaling", new Object[0])));
        Checkbox hideHead = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.hideHeadIfSkull", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.hideHeadIfSkull").updateValueOp(this.editor, this.editor.hideHeadIfSkull, !this.editor.hideHeadIfSkull, (a, b) -> {
                a.hideHeadIfSkull = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> hideHead.setSelected(this.editor.hideHeadIfSkull));
        hideHead.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.hideHeadIfSkull", new Object[0])));
        Checkbox removeArmorOffset = pp.addCheckbox(this.gui.i18nFormat("label.cpm.effect.removeArmorOffset", new Object[0]), () -> {
            this.editor.action("switch", "label.cpm.effect.removeArmorOffset").updateValueOp(this.editor, this.editor.removeArmorOffset, !this.editor.removeArmorOffset, (a, b) -> {
                a.removeArmorOffset = b;
            }).execute();
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> removeArmorOffset.setSelected(this.editor.removeArmorOffset));
        removeArmorOffset.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.effect.removeArmorOffset", new Object[0])));
    }

    private void initDisplayMenu() {
        PopupMenu pp = new PopupMenu(this.gui, this);
        int x = this.topPanel.getX();
        this.topPanel.add(new Button(this.gui, this.gui.i18nFormat("button.cpm.display", new Object[0]), () -> pp.display(x, 20)));
        Checkbox chxbxBase = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.drawBase", new Object[0]), b -> {
            this.editor.renderBase = !b.isSelected();
            b.setSelected(this.editor.renderBase);
        });
        chxbxBase.setSelected(this.editor.renderBase);
        Checkbox chxbxTpose = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.player_tpose", new Object[0]), b -> {
            this.editor.playerTpose = !b.isSelected();
            b.setSelected(this.editor.playerTpose);
        });
        chxbxTpose.setSelected(this.editor.playerTpose);
        Checkbox chxbxAllUVs = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.allUVs", new Object[0]), b -> {
            this.editor.drawAllUVs = !b.isSelected();
            b.setSelected(this.editor.drawAllUVs);
        });
        chxbxAllUVs.setSelected(this.editor.drawAllUVs);
        Checkbox chxbxFilterDraw = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.onlyDrawOnSelected", new Object[0]), b -> {
            this.editor.onlyDrawOnSelected = !b.isSelected();
            b.setSelected(this.editor.onlyDrawOnSelected);
        });
        chxbxFilterDraw.setSelected(this.editor.onlyDrawOnSelected);
        chxbxFilterDraw.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.onlyDrawOnSelected", new Object[0])));
        Checkbox chxbxVanillaAnims = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display.playVanillaAnims", new Object[0]), b -> {
            this.editor.playVanillaAnims = !b.isSelected();
            b.setSelected(this.editor.playVanillaAnims);
        });
        chxbxVanillaAnims.setSelected(this.editor.playVanillaAnims);
        chxbxVanillaAnims.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.display.playVanillaAnims", new Object[0])));
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.display.items", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        PopupMenu heldItemRight = new PopupMenu(this.gui, this);
        Button btnHeldRight = pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.right", new Object[0]), heldItemRight);
        this.initHeldItemPopup(heldItemRight, ItemSlot.RIGHT_HAND);
        this.editor.heldRenderEnable.add(e -> {
            if (!e.booleanValue()) {
                btnHeldRight.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.notSupported", this.gui.i18nFormat("label.cpm.feature.editor_held_item", new Object[0]))));
            }
            btnHeldRight.setEnabled((boolean)e);
        });
        PopupMenu heldItemLeft = new PopupMenu(this.gui, this);
        Button btnHeldLeft = pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.left", new Object[0]), heldItemLeft);
        this.initHeldItemPopup(heldItemLeft, ItemSlot.LEFT_HAND);
        this.editor.heldRenderEnable.add(e -> {
            if (!e.booleanValue()) {
                btnHeldLeft.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.notSupported", this.gui.i18nFormat("label.cpm.feature.editor_held_item", new Object[0]))));
            }
            btnHeldLeft.setEnabled((boolean)e);
        });
        PopupMenu heldItemHead = new PopupMenu(this.gui, this);
        Button btnHeldHead = pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.heldItem.head", new Object[0]), heldItemHead);
        this.initHeldItemPopup(heldItemHead, ItemSlot.HEAD);
        this.editor.heldRenderEnable.add(e -> {
            if (!e.booleanValue()) {
                btnHeldHead.setTooltip(new Tooltip(this, this.gui.i18nFormat("tooltip.cpm.notSupported", this.gui.i18nFormat("label.cpm.feature.editor_held_item", new Object[0]))));
            }
            btnHeldHead.setEnabled((boolean)e);
        });
        pp.add(new Label(this.gui, this.gui.i18nFormat("label.cpm.display.layers", new Object[0])).setBounds(new Box(5, 5, 0, 0)));
        this.addLayerToggle(pp, PlayerModelLayer.CAPE);
        PopupMenu armor = new PopupMenu(this.gui, this);
        pp.addMenuButton(this.gui.i18nFormat("button.cpm.display.armor", new Object[0]), armor);
        for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
            this.addLayerToggle(armor, a);
        }
        armor.addButton(this.gui.i18nFormat("button.cpm.display.toggleArmor", new Object[0]), () -> {
            if (Arrays.stream(PlayerModelLayer.ARMOR).noneMatch(r -> this.editor.modelDisplayLayers.stream().anyMatch(l -> l == r))) {
                for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
                    this.editor.modelDisplayLayers.add(a);
                }
            } else {
                for (PlayerModelLayer a : PlayerModelLayer.ARMOR) {
                    this.editor.modelDisplayLayers.remove((Object)a);
                }
            }
            this.editor.updateGui();
        });
        this.addLayerToggle(pp, PlayerModelLayer.ELYTRA);
    }

    private void addLayerToggle(PopupMenu pp, PlayerModelLayer layer) {
        Checkbox chbx = pp.addCheckbox(this.gui.i18nFormat("label.cpm.display." + layer.name().toLowerCase(), new Object[0]), c -> {
            if (!c.isSelected()) {
                this.editor.modelDisplayLayers.add(layer);
            } else {
                this.editor.modelDisplayLayers.remove((Object)layer);
            }
            this.editor.updateGui();
        });
        this.editor.updateGui.add(() -> chbx.setSelected(this.editor.modelDisplayLayers.contains((Object)layer)));
    }

    private void initHeldItemPopup(PopupMenu pp, ItemSlot hand) {
        ButtonGroup<DisplayItem, Checkbox> group = new ButtonGroup<DisplayItem, Checkbox>(Checkbox::setSelected, Checkbox::setAction, i -> this.editor.handDisplay.put(hand, (DisplayItem)((Object)i)));
        for (DisplayItem item : DisplayItem.VALUES) {
            group.addElement(item, r -> pp.addCheckbox(this.gui.i18nFormat("button.cpm.heldItem." + item.name().toLowerCase(), new Object[0]), (Runnable)r));
        }
        group.accept(this.editor.handDisplay.getOrDefault((Object)hand, DisplayItem.NONE));
    }

    private void load(File file) {
        try {
            this.editor.load(file);
        }
        catch (Exception e) {
            Log.warn("Error loading project file", e);
            this.showError("load", e.toString());
            this.editor.loadDefaultPlayerModel();
        }
    }

    private void saveProject(File file) {
        try {
            this.editor.save(file);
        }
        catch (Exception e) {
            Log.warn("Error saving project file", e);
            this.showError("save", e.toString());
        }
    }

    public void loadSkin(File file) {
        ETextures tex = this.editor.getTextureProvider();
        if (tex != null) {
            tex.file = file;
            this.editor.reloadSkin();
        }
    }

    private void showError(String msg, String error) {
        this.openPopup(new MessagePopup(this, this.gui.i18nFormat("label.cpm.error." + msg, new Object[0]), error));
    }

    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public Box getMinBounds() {
        return new Box(0, 0, 500, 420);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        super.keyPressed(event);
        if (!event.isConsumed()) {
            if (this.gui.isCtrlDown()) {
                if (event.matches("z")) {
                    this.editor.undo();
                    event.consume();
                }
                if (event.matches("y")) {
                    this.editor.redo();
                    event.consume();
                }
                if (event.matches("s")) {
                    this.save();
                }
            }
            if (event.keyCode == this.gui.getKeyCodes().KEY_F5) {
                this.editor.restitchTextures();
                this.editor.animations.forEach(EditorAnim::clearCache);
            }
        }
    }

    public static int getRotateMouseButton() {
        return ModConfig.getCommonConfig().getSetInt("editorRotateMouseButton", 2);
    }

    public static boolean doOpenEditor() {
        return toReopen != null || ModConfig.getCommonConfig().getString("reopenProject", null) != null;
    }

    @Override
    public void logMessage(String msg) {
    }

    @Override
    public void tick() {
        this.editor.tick();
    }

    static {
        smallGuiWarning = true;
        notSupportedWarning = true;
    }
}

