/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.ElementGroup;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTool;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import com.tom.cpm.shared.editor.gui.popup.SkinSettingsPopup;

public class DrawToolsPanel
extends Panel {
    private Editor editor;

    public DrawToolsPanel(EditorGui e, int x, int y, int w, int h) {
        super(e.getGui());
        this.editor = e.getEditor();
        if (w < 70) {
            x -= 70 - w;
            w = 70;
        }
        this.setBounds(new Box(x, y, w, h));
        this.setBackgroundColor(this.gui.getColors().panel_background);
        Panel panel = new Panel(this.gui);
        panel.setBounds(new Box(0, 5, w, h));
        this.addElement(panel);
        FlowLayout layout = new FlowLayout(panel, 5, 1);
        Button openSkinBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.skinSettings", new Object[0]), () -> SkinSettingsPopup.showPopup(e));
        openSkinBtn.setBounds(new Box(5, 0, w - 10, 20));
        panel.addElement(openSkinBtn);
        Button refreshSkinBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.reloadSkin", new Object[0]), this.editor::reloadSkin);
        refreshSkinBtn.setBounds(new Box(5, 0, w - 10, 20));
        panel.addElement(refreshSkinBtn);
        this.editor.setReload.add(f -> {
            refreshSkinBtn.setEnabled(f != null);
            refreshSkinBtn.setTooltip(new Tooltip(e, f != null ? this.gui.i18nFormat("tooltip.cpm.reloadSkin.file", f) : this.gui.i18nFormat("tooltip.cpm.reloadSkin.no_file", new Object[0])));
        });
        ColorButton colorBtn = new ColorButton(this.gui, e, c -> {
            this.editor.penColor = c;
            this.editor.setPenColor.accept(c);
        });
        this.editor.setPenColor.add(colorBtn::setColor);
        colorBtn.setColor(this.editor.penColor);
        colorBtn.setBounds(new Box(5, 0, w - 10, 20));
        panel.addElement(colorBtn);
        Panel toolsPanel = new Panel(this.gui);
        int tx = 0;
        int ty = 0;
        for (EditorTool tool : EditorTool.VALUES) {
            ButtonIcon button = new ButtonIcon(this.gui, "editor", tool.ordinal() * 16, 32, () -> {
                this.editor.drawMode = tool;
                this.editor.setTool.accept(tool);
            });
            if (25 * (tx + 1) > w) {
                tx = 0;
                ++ty;
            }
            button.setBounds(new Box(5 + 25 * tx++, ty * 25, 20, 20));
            this.editor.setTool.add(tool.setEnabled(button));
            toolsPanel.addElement(button);
        }
        toolsPanel.setBounds(new Box(0, 0, w, ty * 25 + 20));
        panel.addElement(toolsPanel);
        ElementGroup<EditorTool, GuiElement> group = new ElementGroup<EditorTool, GuiElement>(GuiElement::setVisible);
        this.editor.setTool.add(group);
        Slider sizeSlider = new Slider(this.gui, this.gui.i18nFormat("label.cpm.brushSize", this.editor.brushSize));
        group.addElement(EditorTool.PEN, sizeSlider);
        group.addElement(EditorTool.RUBBER, sizeSlider);
        sizeSlider.setAction(() -> {
            this.editor.brushSize = Math.max(1, (int)(sizeSlider.getValue() * 10.0f));
            sizeSlider.setText(this.gui.i18nFormat("label.cpm.brushSize", this.editor.brushSize));
        });
        sizeSlider.setBounds(new Box(5, 0, w - 10, 20));
        this.editor.setTool.accept(this.editor.drawMode);
        layout.reflow();
    }
}

