/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.util.CombinedListView;
import com.tom.cpl.util.ListView;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.PosPanel;
import com.tom.cpm.shared.editor.gui.popup.AnimEncConfigPopup;
import com.tom.cpm.shared.editor.gui.popup.AnimationSettinsPopup;
import com.tom.cpm.shared.editor.gui.popup.ColorButton;
import java.util.Collections;

public class AnimPanel
extends Panel {
    private Editor editor;
    private DropDownBox<IAnim> animSel;
    private TabFocusHandler tabHandler;
    private Button prevFrm;
    private Button nextFrm;

    public AnimPanel(final IGui gui, EditorGui e) {
        super(gui);
        this.tabHandler = new TabFocusHandler(gui);
        this.editor = e.getEditor();
        this.setBounds(new Box(0, 0, 170, 330));
        this.setBackgroundColor(gui.getColors().panel_background);
        this.animSel = new DropDownBox(e, new CombinedListView(Collections.singletonList(new IAnim(){

            public String toString() {
                return gui.i18nFormat("label.cpm.no_animation", new Object[0]);
            }
        }), new ListView<EditorAnim, IAnim>(this.editor.animations, v -> v)));
        this.animSel.setBounds(new Box(5, 5, 160, 20));
        this.addElement(this.animSel);
        this.animSel.setAction(() -> {
            IAnim sel = this.animSel.getSelected();
            this.editor.selectedAnim = sel instanceof EditorAnim ? (EditorAnim)sel : null;
            this.editor.updateGui();
        });
        this.editor.setSelAnim.add(this.animSel::setSelected);
        ButtonIcon newAnimBtn = new ButtonIcon(gui, "editor", 0, 16, () -> e.openPopup(new AnimationSettinsPopup(gui, this.editor, false)));
        newAnimBtn.setBounds(new Box(5, 30, 18, 18));
        this.addElement(newAnimBtn);
        ButtonIcon delAnimBtn = new ButtonIcon(gui, "editor", 14, 16, new ConfirmPopup(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnim, null));
        delAnimBtn.setBounds(new Box(25, 30, 18, 18));
        this.addElement(delAnimBtn);
        this.editor.setAnimDelEn.add(delAnimBtn::setEnabled);
        Button editBtn = new Button(gui, gui.i18nFormat("button.cpm.edit", new Object[0]), () -> e.openPopup(new AnimationSettinsPopup(gui, this.editor, true)));
        editBtn.setBounds(new Box(45, 30, 80, 18));
        this.addElement(editBtn);
        this.editor.setAnimDelEn.add(editBtn::setEnabled);
        Label currFrame = new Label(gui, "");
        currFrame.setBounds(new Box(30, 65, 110, 10));
        this.addElement(currFrame);
        this.prevFrm = new Button(gui, "<", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(-1);
            } else {
                this.editor.animPrevFrm();
            }
        });
        this.prevFrm.setBounds(new Box(5, 60, 18, 18));
        this.addElement(this.prevFrm);
        this.nextFrm = new Button(gui, ">", () -> {
            if (gui.isCtrlDown()) {
                this.editor.animMoveFrame(1);
            } else {
                this.editor.animNextFrm();
            }
        });
        this.nextFrm.setBounds(new Box(145, 60, 18, 18));
        this.addElement(this.nextFrm);
        this.editor.setAnimFrame.add(i -> {
            this.prevFrm.setEnabled(i != null);
            this.nextFrm.setEnabled(i != null);
            if (i != null) {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_x", i));
            } else {
                currFrame.setText(gui.i18nFormat("label.cpm.anim_frame_none", new Object[0]));
            }
        });
        ButtonIcon newFrmBtn = new ButtonIcon(gui, "editor", 0, 16, this.editor::addNewAnimFrame);
        newFrmBtn.setBounds(new Box(5, 85, 18, 18));
        this.addElement(newFrmBtn);
        this.editor.setFrameAddEn.add(newFrmBtn::setEnabled);
        ButtonIcon delFrmBtn = new ButtonIcon(gui, "editor", 14, 16, new ConfirmPopup(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnimFrame, null));
        delFrmBtn.setBounds(new Box(25, 85, 18, 18));
        this.addElement(delFrmBtn);
        this.editor.setFrameDelEn.add(delFrmBtn::setEnabled);
        ButtonIcon playBtn = new ButtonIcon(gui, "editor", 56, 16, () -> {
            this.editor.playFullAnim = !this.editor.playFullAnim;
            this.editor.playStartTime = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
            this.editor.setAnimPlay.accept(this.editor.playFullAnim);
        });
        playBtn.setBounds(new Box(45, 85, 18, 18));
        this.addElement(playBtn);
        this.editor.setAnimPlayEn.add(playBtn::setEnabled);
        this.editor.setAnimPlay.add(v -> playBtn.setU(v != false ? 72 : 56));
        Label lblDuration = new Label(gui, gui.i18nFormat("label.cpm.duration", new Object[0]));
        lblDuration.setBounds(new Box(5, 110, 0, 0));
        this.addElement(lblDuration);
        Spinner duration = new Spinner(gui);
        duration.setDp(0);
        duration.setBounds(new Box(5, 120, 100, 18));
        this.addElement(duration);
        this.editor.setAnimDuration.add(i -> {
            duration.setEnabled(i != null);
            if (i != null) {
                duration.setValue(i.intValue());
            } else {
                duration.setValue(1000.0f);
            }
        });
        duration.addChangeListener(() -> this.editor.setAnimDuration((int)duration.getValue()));
        this.tabHandler.add(duration);
        PosPanel.addVec3("rotation", 145, v -> this.editor.setAnimRot((Vec3f)v), this, this.editor.setAnimRot, 1, this.tabHandler);
        PosPanel.addVec3("position", 175, v -> this.editor.setAnimPos((Vec3f)v), this, this.editor.setAnimPos, 2, this.tabHandler);
        ColorButton colorBtn = new ColorButton(gui, e, this.editor::setAnimColor);
        colorBtn.setBounds(new Box(5, 205, 140, 20));
        this.editor.setAnimColor.add(c -> {
            colorBtn.setEnabled(c != null);
            if (c != null) {
                colorBtn.setColor((int)c);
            } else {
                colorBtn.setColor(0);
            }
        });
        this.addElement(colorBtn);
        Checkbox boxShow = new Checkbox(gui, gui.i18nFormat("label.cpm.visible", new Object[0]));
        boxShow.setBounds(new Box(5, 230, 60, 18));
        boxShow.setAction(this.editor::switchAnimShow);
        this.editor.setAnimShow.add(boxShow::updateState);
        this.addElement(boxShow);
        Button encSettings = new Button(gui, gui.i18nFormat("button.cpm.animEncSettings", new Object[0]), () -> e.openPopup(new AnimEncConfigPopup(gui, this.editor, null)));
        encSettings.setBounds(new Box(5, 260, 155, 20));
        this.addElement(encSettings);
        Label lblPri = new Label(gui, gui.i18nFormat("label.cpm.anim_priority", new Object[0]));
        lblPri.setBounds(new Box(5, 290, 160, 10));
        lblPri.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.anim_priority", new Object[0])));
        this.addElement(lblPri);
        Button clearAnimData = new Button(gui, gui.i18nFormat("button.cpm.clearAnimData", new Object[0]), new ConfirmPopup(e, gui.i18nFormat("label.cpm.confirmDel", new Object[0]), this.editor::delSelectedAnimPartData, null));
        clearAnimData.setBounds(new Box(110, 120, 55, 18));
        clearAnimData.setTooltip(new Tooltip(e, gui.i18nFormat("tooltip.cpm.clearAnimData", new Object[0])));
        this.addElement(clearAnimData);
        Spinner animPriority = new Spinner(gui);
        this.editor.setAnimPriority.add(v -> {
            animPriority.setEnabled(v != null);
            if (v != null) {
                animPriority.setValue(v.intValue());
            } else {
                animPriority.setValue(0.0f);
            }
        });
        animPriority.setBounds(new Box(5, 300, 100, 18));
        animPriority.setDp(0);
        animPriority.addChangeListener(() -> this.editor.setAnimPriority((int)animPriority.getValue()));
        this.addElement(animPriority);
        this.tabHandler.add(animPriority);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.editor.playFullAnim = false;
            IAnim sel = this.animSel.getSelected();
            this.editor.selectedAnim = sel instanceof EditorAnim ? (EditorAnim)sel : null;
            this.editor.setAnimPlay.accept(false);
            this.editor.updateGui();
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        if (this.gui.isCtrlDown()) {
            this.prevFrm.setText("<<");
            this.nextFrm.setText(">>");
        } else {
            this.prevFrm.setText("<");
            this.nextFrm.setText(">");
        }
        super.draw(event, partialTicks);
    }

    public static interface IAnim {
    }
}

