/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.ElementType;
import com.tom.cpm.shared.editor.ModelElement;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.project.JsonList;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class AnimFrame {
    private final Map<ModelElement, Data> components = new HashMap<ModelElement, Data>();
    private EditorAnim anim;

    public AnimFrame(EditorAnim anim) {
        this.anim = anim;
    }

    public AnimFrame(AnimFrame cpy) {
        this.anim = cpy.anim;
        for (Map.Entry<ModelElement, Data> e : cpy.components.entrySet()) {
            this.components.put(e.getKey(), new Data(e.getValue()));
        }
    }

    public void setPos(ModelElement elem, Vec3f v) {
        Data dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.position");
        if (dt == null) {
            dt = new Data(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.pos, v, (a, b) -> ((Data)a).pos = b);
        ab.execute();
    }

    public void setRot(ModelElement elem, Vec3f v) {
        Data dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.rotation");
        if (dt == null) {
            dt = new Data(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.rot, v, (a, b) -> ((Data)a).rot = b);
        ab.execute();
    }

    public void setColor(ModelElement elem, int rgb) {
        Data dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.rotation");
        if (dt == null) {
            dt = new Data(elem);
            ab.addToMap(this.components, elem, dt);
        }
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        ab.updateValueOp(dt, dt.color, new Vec3f(r, g, b), (a, v) -> ((Data)a).color = v);
        ab.execute();
    }

    public void switchVis(ModelElement elem) {
        Data dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.hidden_effect");
        if (dt == null) {
            dt = new Data(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.show, !dt.show, (a, b) -> ((Data)a).show = b);
        ab.execute();
    }

    public IElem getData(ModelElement modelElement) {
        return this.components.get(modelElement);
    }

    public void apply() {
        this.components.values().forEach(rec$ -> ((Data)rec$).apply());
    }

    public boolean getVisible(ModelElement component) {
        if (!this.components.containsKey(component)) {
            return !component.hidden && component.rc.doDisplay();
        }
        return this.components.get(component).show;
    }

    public Stream<ModelElement> getAllElements() {
        return this.components.keySet().stream();
    }

    public Stream<ModelElement> getAllElementsFiltered() {
        return this.components.entrySet().stream().filter(e -> ((Data)e.getValue()).hasChanges()).map(Map.Entry::getKey);
    }

    public void loadFrom(JsonMap data) {
        JsonList c = data.getList("components");
        c.forEachMap(map -> {
            long sid = map.getLong("storeID");
            Editor.walkElements(this.anim.editor.elements, elem -> {
                if (elem.storeID == sid) {
                    Data dt = new Data((ModelElement)elem);
                    this.components.put((ModelElement)elem, dt);
                    dt.pos = new Vec3f(map.getMap("pos"), new Vec3f());
                    dt.rot = new Vec3f(map.getMap("rotation"), new Vec3f());
                    int rgb = Integer.parseUnsignedInt(map.getString("color"), 16);
                    int r = (rgb & 0xFF0000) >> 16;
                    int g = (rgb & 0xFF00) >> 8;
                    int b = rgb & 0xFF;
                    dt.color = new Vec3f(r, g, b);
                    dt.show = map.getBoolean("show");
                }
            });
        });
    }

    public Map<String, Object> store() {
        ArrayList c = new ArrayList();
        for (Map.Entry<ModelElement, Data> e : this.components.entrySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            c.add(map);
            map.put("storeID", e.getKey().storeID);
            Data dt = e.getValue();
            map.put("pos", dt.pos.toMap());
            map.put("rotation", dt.rot.toMap());
            int rgb = (int)((Data)dt).color.x << 16 | (int)((Data)dt).color.y << 8 | (int)((Data)dt).color.z;
            map.put("color", Integer.toHexString(rgb));
            map.put("show", dt.show);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("components", c);
        return data;
    }

    public boolean hasPosChanges(ModelElement me) {
        Data data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasPosChanges();
    }

    public boolean hasRotChanges(ModelElement me) {
        Data data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasRotChanges();
    }

    public boolean hasColorChanges(ModelElement me) {
        Data data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasColorChanges();
    }

    public boolean hasVisChanges(ModelElement me) {
        Data data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasVisChanges();
    }

    public void copy(AnimFrame from) {
        from.components.forEach((e, dt) -> this.components.put((ModelElement)e, new Data((Data)dt)));
    }

    public void clearSelectedData(ModelElement me) {
        this.components.remove(me);
    }

    public static float[] toArray(EditorAnim anim, ModelElement elem, InterpolatorChannel channel) {
        float[] data = new float[anim.getFrames().size()];
        for (int i = 0; i < anim.getFrames().size(); ++i) {
            AnimFrame frm = anim.getFrames().get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (anim.add) {
                    data[i] = 0.0f;
                    continue;
                }
                data[i] = elem.part(channel);
                continue;
            }
            data[i] = dt.part(channel);
        }
        return data;
    }

    private class Data
    implements IElem {
        private Vec3f pos;
        private Vec3f rot;
        private Vec3f color;
        private boolean show = true;
        private ModelElement comp;

        public Data(ModelElement comp) {
            this.comp = comp;
            if (!((AnimFrame)AnimFrame.this).anim.add) {
                if (comp.type == ElementType.ROOT_PART) {
                    PartValues val = ((VanillaModelPart)comp.typeData).getDefaultSize(((AnimFrame)AnimFrame.this).anim.editor.skinType);
                    this.pos = val.getPos();
                    this.rot = new Vec3f();
                } else {
                    this.pos = new Vec3f(comp.pos);
                    this.rot = new Vec3f(comp.rotation);
                }
            } else {
                this.pos = new Vec3f();
                this.rot = new Vec3f();
            }
            int r = (comp.rgb & 0xFF0000) >> 16;
            int g = (comp.rgb & 0xFF00) >> 8;
            int b = comp.rgb & 0xFF;
            this.color = new Vec3f(r, g, b);
            this.show = !comp.hidden;
        }

        public Data(Data cpy) {
            this.comp = cpy.comp;
            this.pos = new Vec3f(cpy.pos);
            this.rot = new Vec3f(cpy.rot);
            this.color = new Vec3f(cpy.color);
            this.show = cpy.show;
        }

        @Override
        public Vec3f getPosition() {
            return this.pos;
        }

        @Override
        public Vec3f getRotation() {
            return this.rot;
        }

        @Override
        public Vec3f getColor() {
            return this.color;
        }

        @Override
        public boolean isVisible() {
            return this.show;
        }

        private void apply() {
            this.comp.rc.setRotation(((AnimFrame)AnimFrame.this).anim.add, (float)Math.toRadians(this.rot.x), (float)Math.toRadians(this.rot.y), (float)Math.toRadians(this.rot.z));
            this.comp.rc.setPosition(((AnimFrame)AnimFrame.this).anim.add, this.pos.x, this.pos.y, this.pos.z);
            this.comp.rc.setColor(this.color.x, this.color.y, this.color.z);
            this.comp.rc.display = this.show;
        }

        public boolean hasChanges() {
            return this.hasPosChanges() || this.hasRotChanges() || this.hasColorChanges() || this.hasVisChanges();
        }

        public boolean hasPosChanges() {
            if (((AnimFrame)AnimFrame.this).anim.add) {
                return Math.abs(this.pos.x) > 0.01f || Math.abs(this.pos.y) > 0.01f || Math.abs(this.pos.z) > 0.01f;
            }
            return Math.abs(this.pos.x - this.comp.pos.x) > 0.01f || Math.abs(this.pos.y - this.comp.pos.y) > 0.01f || Math.abs(this.pos.z - this.comp.pos.z) > 0.01f;
        }

        public boolean hasRotChanges() {
            if (((AnimFrame)AnimFrame.this).anim.add) {
                return Math.abs(this.rot.x) > 0.01f || Math.abs(this.rot.y) > 0.01f || Math.abs(this.rot.z) > 0.01f;
            }
            return Math.abs(this.rot.x - this.comp.rotation.x) > 0.01f || Math.abs(this.rot.y - this.comp.rotation.y) > 0.01f || Math.abs(this.rot.z - this.comp.rotation.z) > 0.01f;
        }

        public boolean hasColorChanges() {
            int rgb;
            return (!this.comp.texture || this.comp.recolor) && (this.comp.rgb & 0xFFFFFF) != ((rgb = (int)this.color.x << 16 | (int)this.color.y << 8 | (int)this.color.z) & 0xFFFFFF);
        }

        public boolean hasVisChanges() {
            return this.comp.hidden == this.show;
        }
    }
}

