/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.actions;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.definition.ListAction;
import com.tom.cpm.shared.definition.MapAction;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.actions.Action;
import com.tom.cpm.shared.editor.actions.RunnableAction;
import com.tom.cpm.shared.editor.actions.ValueAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ActionBuilder
extends Action {
    private final Editor e;
    private List<Action> actions = new ArrayList<Action>();

    public ActionBuilder(Editor e) {
        this.e = e;
    }

    public ActionBuilder(Editor e, String name) {
        super(name);
        this.e = e;
    }

    @Override
    @Deprecated
    public void undo() {
        this.actions.forEach(Action::undo);
    }

    @Override
    @Deprecated
    public void run() {
        this.actions.forEach(Action::run);
    }

    public <E, T> ActionBuilder updateValueOp(E elem, T currVal, T newVal, BiConsumer<E, T> setter) {
        this.actions.add(new ValueAction<E, T>(elem, setter, currVal, newVal));
        return this;
    }

    public <E, T> ActionBuilder updateValueOp(E elem, T currVal, T newVal, BiConsumer<E, T> setter, Consumer<T> updater) {
        this.actions.add(new ValueAction<Object, Object>(elem, (e, t) -> {
            setter.accept(e, t);
            updater.accept(t);
        }, currVal, newVal));
        return this;
    }

    public <E, T extends Number> ActionBuilder updateValueOp(E elem, T currVal, T newVal, T min, T max, BiConsumer<E, T> setter, Consumer<T> updater) {
        if (newVal.floatValue() > max.floatValue()) {
            newVal = max;
            updater.accept(newVal);
        }
        if (newVal.floatValue() < min.floatValue()) {
            newVal = min;
            updater.accept(newVal);
        }
        this.updateValueOp(elem, currVal, newVal, setter);
        return this;
    }

    public <E> ActionBuilder updateValueOp(E elem, Vec3f currVal, Vec3f newVal, int min, int max, boolean wrap, BiConsumer<E, Vec3f> setter, Consumer<Vec3f> updater) {
        boolean changed = false;
        if (newVal.x < (float)min || newVal.x > (float)max) {
            newVal.x = ActionBuilder.calcVal(newVal.x, min, max, wrap);
            changed = true;
        }
        if (newVal.y < (float)min || newVal.y > (float)max) {
            newVal.y = ActionBuilder.calcVal(newVal.y, min, max, wrap);
            changed = true;
        }
        if (newVal.z < (float)min || newVal.z > (float)max) {
            newVal.z = ActionBuilder.calcVal(newVal.z, min, max, wrap);
            changed = true;
        }
        if (changed) {
            updater.accept(newVal);
        }
        this.updateValueOp(elem, currVal, newVal, setter);
        return this;
    }

    private static float calcVal(float val, int min, int max, boolean wrap) {
        if (val < (float)min) {
            if (wrap) {
                while (val < (float)min) {
                    val += (float)max;
                }
            } else {
                val = min;
            }
        }
        if (val > (float)max) {
            if (wrap) {
                while (val >= (float)max) {
                    val -= (float)max;
                }
            } else {
                val = max;
            }
        }
        return val;
    }

    public <T> ActionBuilder addToList(List<T> list, T value) {
        this.actions.add(ListAction.add(value, list));
        return this;
    }

    public <T> ActionBuilder removeFromList(List<T> list, T value) {
        this.actions.add(ListAction.remove(value, list));
        return this;
    }

    public <K, V> ActionBuilder addToMap(Map<K, V> map, K key, V value) {
        this.actions.add(MapAction.add(map, key, value));
        return this;
    }

    public <K, V> ActionBuilder removeFromMap(Map<K, V> map, K key, V value) {
        this.actions.add(MapAction.remove(map, key, value));
        return this;
    }

    public <T> ActionBuilder update(Consumer<T> updater, T value) {
        this.actions.add(new RunnableAction(() -> updater.accept(value), null));
        return this;
    }

    public ActionBuilder action(Action action) {
        this.actions.add(action);
        return this;
    }

    public ActionBuilder runnable(Runnable run, Runnable undo) {
        this.actions.add(new RunnableAction(run, undo));
        return this;
    }

    public ActionBuilder onUndo(Runnable undo) {
        this.actions.add(new RunnableAction(null, undo));
        return this;
    }

    public ActionBuilder onRun(Runnable run) {
        this.actions.add(new RunnableAction(run, null));
        return this;
    }

    public ActionBuilder onAction(Runnable run) {
        this.actions.add(new RunnableAction(run, run));
        return this;
    }

    public void execute() {
        this.e.executeAction(this);
        this.e.markDirty();
    }
}

