/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.util.Image;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.EditorTexture;
import com.tom.cpm.shared.editor.tree.TreeElement;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.util.TextureStitcher;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;

public class ETextures
implements TreeElement {
    public static final int MAX_TEX_SIZE = 8192;
    private final Editor e;
    private TextureSheetType type;
    public EditorTexture provider;
    private EditorTexture renderTexture;
    public TextureStitcher stitcher;
    public Consumer<TextureStitcher> textureLoader;
    public File file;
    private Image defaultImg;

    public ETextures(Editor e, TextureSheetType type) {
        this(e, type, null);
    }

    public ETextures(Editor e, TextureSheetType type, Consumer<TextureStitcher> textureLoader) {
        this(e, new EditorTexture());
        this.type = type;
        this.textureLoader = textureLoader;
        if (textureLoader != null) {
            this.renderTexture = new EditorTexture();
            this.stitcher = new TextureStitcher(8192);
        }
    }

    public ETextures(Editor e, EditorTexture provider) {
        this.e = e;
        this.provider = provider;
    }

    public void free() {
        this.provider.free();
        if (this.textureLoader != null) {
            this.renderTexture.free();
        }
    }

    public void clean() {
        this.provider.texture = null;
        this.provider.setEdited(false);
        this.file = null;
    }

    public void markDirty() {
        this.provider.markDirty();
        this.refreshTexture();
    }

    public boolean isEdited() {
        return this.provider.isEdited();
    }

    public void setEdited(boolean edited) {
        this.provider.setEdited(edited);
    }

    public void refreshTexture(EditorTexture tex) {
        if (this.textureLoader == null) {
            return;
        }
        if (this.stitcher.refresh(tex.getImage())) {
            this.renderTexture.markDirty();
        }
    }

    public void restitchTexture() {
        if (this.textureLoader == null) {
            return;
        }
        this.stitcher = new TextureStitcher(8192);
        this.stitcher.setBase(this.provider);
        this.textureLoader.accept(this.stitcher);
        this.stitcher.finish(this.renderTexture);
        this.renderTexture.markDirty();
    }

    public void setRGB(int x, int y, int rgb) {
        this.provider.setRGB(x, y, rgb);
    }

    public void write(IOHelper dout) throws IOException {
        this.provider.write(dout);
    }

    public void setImage(Image image) {
        this.provider.setImage(image);
    }

    public void refreshTexture() {
        this.refreshTexture(this.provider);
    }

    public Image getImage() {
        return this.provider.getImage();
    }

    public boolean hasStitches() {
        if (this.textureLoader == null) {
            return false;
        }
        return this.stitcher.hasStitches();
    }

    public EditorTexture getRenderTexture() {
        return this.textureLoader != null ? this.renderTexture : this.provider;
    }

    @Override
    public String getName() {
        return this.e.gui().i18nFormat("label.cpm.texture." + this.type.name().toLowerCase(), new Object[0]);
    }

    @Override
    public ETextures getTexture() {
        return this;
    }

    public void setDefaultImg(Image defaultImg) {
        this.defaultImg = defaultImg;
    }

    public Image copyDefaultImg() {
        return new Image(this.defaultImg);
    }

    public boolean isEditable() {
        return this.type != null ? this.type.editable : false;
    }

    @Override
    public int textColor() {
        return this.isEdited() ? 0 : this.e.gui().getColors().button_text_disabled;
    }
}

