/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.tom.cpl.util.Image;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.ResourceLoader;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.io.ChecksumInputStream;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.SkinDataInputStream;
import com.tom.cpm.shared.loaders.GistResourceLoader;
import com.tom.cpm.shared.loaders.GithubRepoResourceLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.ModelPartEnd;
import com.tom.cpm.shared.parts.ModelPartSkinType;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.skin.TextureType;
import com.tom.cpm.shared.util.Log;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public class ModelDefinitionLoader<GP> {
    public static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private Function<GP, Player<?, ?>> playerFactory;
    private Function<GP, UUID> getUUID;
    private Function<GP, String> getName;
    private final LoadingCache<Key, Player<?, ?>> cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).removalListener(new RemovalListener<Key, Player<?, ?>>(){

        public void onRemoval(RemovalNotification<Key, Player<?, ?>> notification) {
            ((Player)notification.getValue()).cleanup();
        }
    }).build(new CacheLoader<Key, Player<?, ?>>(){

        public Player<?, ?> load(Key key) throws Exception {
            Player player = (Player)ModelDefinitionLoader.this.playerFactory.apply(key.profile);
            if (ModelDefinitionLoader.this.serverModels.containsKey(key)) {
                player.setModelDefinition(CompletableFuture.supplyAsync(() -> ModelDefinitionLoader.this.loadModel((byte[])ModelDefinitionLoader.this.serverModels.get(key), player), THREAD_POOL));
            } else {
                player.setModelDefinition((CompletableFuture<ModelDefinition>)((CompletableFuture)player.getTextures().load().thenCompose(v -> player.getTextures().getTexture(TextureType.SKIN))).thenApplyAsync(skin -> {
                    if (skin != null && player.getModelDefinition() == null) {
                        return ModelDefinitionLoader.this.loadModel((Image)skin, (Player<?, ?>)player);
                    }
                    return null;
                }, (Executor)THREAD_POOL));
            }
            return player;
        }
    });
    private static final Map<String, ResourceLoader> LOADERS = new HashMap<String, ResourceLoader>();
    private final Cache<Link, Link.ResolvedLink> linkCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final Cache<Link, Link.ResolvedLink> localCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private ConcurrentHashMap<Key, byte[]> serverModels = new ConcurrentHashMap();
    private Image template;
    public static final int HEADER = 83;

    public ModelDefinitionLoader(Function<GP, Player<?, ?>> playerFactory, Function<GP, UUID> getUUID, Function<GP, String> getName) {
        try (InputStream is = ModelDefinitionLoader.class.getResourceAsStream("/assets/cpm/textures/template/free_space_template.png");){
            this.template = Image.loadFrom(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load template", e);
        }
        this.playerFactory = playerFactory;
        this.getUUID = getUUID;
        this.getName = getName;
    }

    public Player<?, ?> loadPlayer(GP player) {
        try {
            return (Player)this.cache.get((Object)new Key(player));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelDefinition loadModel(byte[] data, Player<?, ?> player) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            ModelDefinition modelDefinition = this.loadModel(in, player);
            return modelDefinition;
        }
        catch (Exception e) {
            return new ModelDefinition(e, player);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModelDefinition loadModel(Image skin, Player<?, ?> player) {
        try (SkinDataInputStream in = new SkinDataInputStream(skin, this.template, player.getSkinType().getChannel());){
            ModelDefinition modelDefinition = this.loadModel(in, player);
            return modelDefinition;
        }
        catch (Exception e) {
            return new ModelDefinition(e, player);
        }
    }

    private ModelDefinition loadModel(InputStream in, Player<?, ?> player) throws IOException {
        ModelDefinition def = new ModelDefinition(this, player);
        try {
            if (in.read() != 83) {
                return null;
            }
            ConfigKeys.ENABLE_MODEL_LOADING.checkFor(player, (Boolean)((Object)((Predicate<Boolean>)v -> v)), SafetyException.BlockReason.CONFIG_DISABLED);
            if (SocialConfig.isBlocked(player.getUUID().toString())) {
                throw new SafetyException(SafetyException.BlockReason.BLOCK_LIST);
            }
            ChecksumInputStream cis = new ChecksumInputStream(in);
            IOHelper din = new IOHelper(cis);
            ArrayList<IModelPart> parts = new ArrayList<IModelPart>();
            while (true) {
                IModelPart part;
                if ((part = (IModelPart)din.readObjectBlock(ModelPartType.VALUES, (t, d) -> t.getFactory().create(d, def))) == null) continue;
                if (part instanceof ModelPartSkinType && in instanceof SkinDataInputStream) {
                    SkinDataInputStream sin = (SkinDataInputStream)in;
                    SkinType type = ((ModelPartSkinType)part).getSkinType();
                    if (type != SkinType.UNKNOWN && type.getChannel() != sin.getChannel()) {
                        sin.setChannel(type.getChannel());
                        Log.debug("Mismatching skin type");
                    }
                }
                if (part instanceof ModelPartEnd) break;
                parts.add(part);
            }
            cis.checkSum();
            def.setParts(parts);
            def.validate();
            Log.debug(def);
        }
        catch (SafetyException e) {
            def.setModelBlocked(e);
        }
        catch (Throwable e) {
            def.setError(e);
        }
        return def;
    }

    public InputStream load(Link link, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws IOException {
        try {
            Link.ResolvedLink rl = (Link.ResolvedLink)this.linkCache.get((Object)link, () -> this.load0(link, enc, def));
            return rl.getData();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SafetyException) {
                throw (SafetyException)e.getCause();
            }
            throw new IOException(e);
        }
    }

    private Link.ResolvedLink load0(Link link, ResourceLoader.ResourceEncoding enc, ModelDefinition def) throws SafetyException {
        try {
            ResourceLoader rl = LOADERS.get(link.loader);
            if (rl == null) {
                throw new IOException("Couldn't find loader");
            }
            return new Link.ResolvedLink(rl.loadResource(link.path, enc, def));
        }
        catch (SafetyException e) {
            throw e;
        }
        catch (IOException e) {
            Link.ResolvedLink rl = (Link.ResolvedLink)this.localCache.getIfPresent((Object)link);
            if (rl != null) {
                return rl;
            }
            return new Link.ResolvedLink(e);
        }
    }

    public Image getTemplate() {
        return this.template;
    }

    public void putLocalResource(Link key, byte[] value) {
        this.localCache.put((Object)key, (Object)new Link.ResolvedLink(value));
    }

    public void clearCache() {
        this.linkCache.invalidateAll();
        this.cache.invalidateAll();
    }

    public void clearServerData() {
        this.serverModels.clear();
    }

    public void setModel(GP forPlayer, byte[] data, boolean forced) {
        if (data == null) {
            Key key = new Key(forPlayer);
            this.serverModels.remove(key);
            this.cache.invalidate((Object)key);
        } else {
            Player<?, ?> player = this.loadPlayer(forPlayer);
            player.setModelDefinition(CompletableFuture.completedFuture(this.loadModel(data, player)));
            player.forcedSkin = forced;
            this.serverModels.put(new Key(forPlayer), data);
        }
    }

    public void execute(Runnable task) {
        THREAD_POOL.execute(task);
    }

    public List<Player<?, ?>> getPlayers() {
        return new ArrayList(this.cache.asMap().values());
    }

    public void settingsChanged(UUID uuid) {
        this.cache.invalidate((Object)new Key(uuid));
    }

    public UUID getGP_UUID(GP gp) {
        return this.getUUID.apply(gp);
    }

    public String getGP_Name(GP gp) {
        return this.getName.apply(gp);
    }

    static {
        LOADERS.put("git", new GistResourceLoader());
        LOADERS.put("gh", new GithubRepoResourceLoader());
    }

    private class Key {
        private UUID uuid;
        private GP profile;

        public Key(GP player) {
            this.profile = player;
            this.uuid = (UUID)ModelDefinitionLoader.this.getUUID.apply(player);
        }

        public Key(UUID uuid) {
            this.uuid = uuid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

