/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.config;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.config.ModConfig;
import java.util.Base64;

public class PlayerData {
    public byte[] data;
    public boolean forced;
    public boolean save;
    public float scale;

    public void setModel(byte[] data, boolean forced, boolean save) {
        this.data = data;
        this.forced = forced;
        this.save = save;
    }

    public void setModel(String data, boolean forced, boolean save) {
        this.data = data != null ? Base64.getDecoder().decode(data) : null;
        this.forced = forced;
        this.save = save;
    }

    public boolean canChangeModel() {
        return this.data == null || !this.forced;
    }

    public void load(String id) {
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins").getEntry(id);
        boolean forced = e.getBoolean("forced", false);
        String b64 = e.getString("model", null);
        if (b64 != null) {
            this.setModel(b64, forced, true);
        }
    }

    public void save(String id) {
        ConfigEntry e = ModConfig.getWorldConfig().getEntry("skins");
        if (this.save) {
            if (this.data == null) {
                e.clearValue(id);
            } else {
                e = e.getEntry(id);
                e.setString("model", Base64.getEncoder().encodeToString(this.data));
                e.setBoolean("forced", this.forced);
            }
        } else {
            e.clearValue(id);
        }
        ModConfig.getWorldConfig().save();
    }
}

